/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.output;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.output.EnrollOutput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import java.util.Map;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS12Output
extends EnrollOutput {
    public static Logger logger = LoggerFactory.getLogger(PKCS12Output.class);
    public static final String VAL_P12_RESPONSE = "p12_response";

    public PKCS12Output() {
        this.addValueName(VAL_P12_RESPONSE);
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_PKCS12", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_PKCS12_TEXT", (String[])new String[0]);
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws EProfileException {
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_P12_RESPONSE)) {
            return new Descriptor("server_side_keygen_p12", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_PKCS12", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public String getValue(String name, Locale locale, Request request) throws EProfileException {
        if (name.equals(VAL_P12_RESPONSE)) {
            try {
                byte[] pkcs12 = request.getExtDataInByteArray("req_issued_p12");
                if (pkcs12 != null) {
                    logger.debug("PKCS12Output:getValue: found p12");
                    String pkcs12Str = Utils.base64encodeSingleLine((byte[])pkcs12);
                    return pkcs12Str;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

