/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.dbs.DBVirtualList;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.dbs.certdb.RenewableCertificateCollection;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DBSearchResults;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.DateMapper;
import com.netscape.cmscore.dbs.Repository;
import com.netscape.cmscore.dbs.RevocationInfo;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPSearchResults;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateRepository
extends Repository {
    public static Logger logger = LoggerFactory.getLogger(CertificateRepository.class);
    public static final int ALL_CERTS = 0;
    public static final int ALL_VALID_CERTS = 1;
    public static final int ALL_UNREVOKED_CERTS = 2;
    public static final String PROP_INCREMENT = "certdbInc";
    public static final String PROP_TRANS_MAXRECORDS = "transitMaxRecords";
    public static final String PROP_TRANS_PAGESIZE = "transitRecordPageSize";
    public final String CERT_X509ATTRIBUTE = "x509signedcert";
    private static final String PROP_ENABLE_RANDOM_SERIAL_NUMBERS = "enableRandomSerialNumbers";
    private static final String PROP_RANDOM_SERIAL_NUMBER_COUNTER = "randomSerialNumberCounter";
    private static final String PROP_FORCE_MODE_CHANGE = "forceModeChange";
    private static final String PROP_RANDOM_MODE = "random";
    private static final String PROP_SEQUENTIAL_MODE = "sequential";
    private static final String PROP_COLLISION_RECOVERY_STEPS = "collisionRecoverySteps";
    private static final String PROP_COLLISION_RECOVERY_REGENERATIONS = "collisionRecoveryRegenerations";
    private static final String PROP_MINIMUM_RANDOM_BITS = "minimumRandomBits";
    private static final BigInteger BI_MINUS_ONE = BigInteger.ONE.negate();
    public static final String PROP_CERT_ID_GENERATOR = "cert.id.generator";
    public static final String DEFAULT_CERT_ID_GENERATOR = "legacy";
    public static final String PROP_CERT_ID_LENGTH = "cert.id.length";
    private boolean mConsistencyCheck = false;
    private boolean mEnableRandomSerialNumbers;
    private int mBitLength = 0;
    private BigInteger mRangeSize = null;
    private int mMinRandomBitLength = 4;
    private int mMaxCollisionRecoverySteps = 10;
    private int mMaxCollisionRecoveryRegenerations = 3;
    private DatabaseConfig mDBConfig = null;
    private boolean mForceModeChange = false;

    public CertificateRepository(SecureRandom secureRandom, DBSubsystem dbSubsystem) {
        super(dbSubsystem, 16);
        this.secureRandom = secureRandom;
    }

    public void init() throws Exception {
        logger.debug("CertificateRepository: Initializing certificate repository");
        this.mDBConfig = this.dbSubsystem.getDBConfigStore();
        this.mBaseDN = this.mDBConfig.getSerialDN() + "," + this.dbSubsystem.getBaseDN();
        logger.debug("CertificateRepository: - base DN: " + this.mBaseDN);
        String value = this.mDBConfig.getString(PROP_CERT_ID_GENERATOR, DEFAULT_CERT_ID_GENERATOR);
        logger.debug("CertificateRepository: - cert ID generator: " + value);
        this.setIDGenerator(value);
        if (this.idGenerator == Repository.IDGenerator.RANDOM) {
            this.idLength = this.mDBConfig.getInteger(PROP_CERT_ID_LENGTH);
            logger.debug("CertificateRepository: - cert ID length: " + this.idLength);
        } else {
            this.initLegacyGenerator();
        }
    }

    public void initLegacyGenerator() throws Exception {
        String incrementNo;
        this.rangeDN = this.mDBConfig.getSerialRangeDN() + "," + this.dbSubsystem.getBaseDN();
        logger.debug("CertificateRepository: - range DN: " + this.rangeDN);
        this.minSerialName = "beginSerialNumber";
        String minSerial = this.mDBConfig.getBeginSerialNumber();
        if (minSerial != null) {
            this.mMinSerialNo = new BigInteger(minSerial, this.mRadix);
        }
        logger.debug("CertificateRepository: - min serial: " + this.mMinSerialNo);
        this.maxSerialName = "endSerialNumber";
        String maxSerial = this.mDBConfig.getEndSerialNumber();
        if (maxSerial != null) {
            this.mMaxSerialNo = new BigInteger(maxSerial, this.mRadix);
        }
        logger.debug("CertificateRepository: - max serial: " + this.mMaxSerialNo);
        this.nextMinSerialName = "nextBeginSerialNumber";
        String nextMinSerial = this.mDBConfig.getNextBeginSerialNumber();
        this.mNextMinSerialNo = nextMinSerial == null || nextMinSerial.equals("-1") ? null : new BigInteger(nextMinSerial, this.mRadix);
        logger.debug("CertificateRepository: - next min serial: " + this.mNextMinSerialNo);
        this.nextMaxSerialName = "nextEndSerialNumber";
        String nextMaxSerial = this.mDBConfig.getNextEndSerialNumber();
        this.mNextMaxSerialNo = nextMaxSerial == null || nextMaxSerial.equals("-1") ? null : new BigInteger(nextMaxSerial, this.mRadix);
        logger.debug("CertificateRepository: - next max serial: " + this.mNextMaxSerialNo);
        String lowWaterMark = this.mDBConfig.getSerialLowWaterMark();
        if (lowWaterMark != null) {
            this.mLowWaterMarkNo = new BigInteger(lowWaterMark, this.mRadix);
        }
        if ((incrementNo = this.mDBConfig.getSerialIncrement()) != null) {
            this.mIncrementNo = new BigInteger(incrementNo, this.mRadix);
        }
    }

    public boolean getEnableRandomSerialNumbers() {
        return this.mEnableRandomSerialNumbers;
    }

    public void setEnableRandomSerialNumbers(boolean random, boolean updateMode, boolean forceModeChange) {
        logger.debug("CertificateRepository:  setEnableRandomSerialNumbers   random=" + random + "  updateMode=" + updateMode);
        EngineConfig cs = this.engine.getConfig();
        if (this.mEnableRandomSerialNumbers ^ random || forceModeChange) {
            this.mEnableRandomSerialNumbers = random;
            logger.debug("CertificateRepository:  setEnableRandomSerialNumbers   switching to " + (random ? PROP_RANDOM_MODE : PROP_SEQUENTIAL_MODE) + " mode");
            if (updateMode) {
                this.setCertificateRepositoryMode(this.mEnableRandomSerialNumbers ? PROP_RANDOM_MODE : PROP_SEQUENTIAL_MODE);
            }
            this.mDBConfig.putBoolean(PROP_ENABLE_RANDOM_SERIAL_NUMBERS, this.mEnableRandomSerialNumbers);
            BigInteger lastSerialNumber = null;
            try {
                lastSerialNumber = this.getLastSerialNumberInRange(this.mMinSerialNo, this.mMaxSerialNo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lastSerialNumber != null) {
                super.setLastSerialNo(lastSerialNumber);
                if (this.mEnableRandomSerialNumbers) {
                    this.mCounter = lastSerialNumber.subtract(this.mMinSerialNo).add(BigInteger.ONE);
                    logger.debug("CertificateRepository:  setEnableRandomSerialNumbers  mCounter=" + this.mCounter + "=" + lastSerialNumber + "-" + this.mMinSerialNo + "+1");
                    long t = System.currentTimeMillis();
                    this.mDBConfig.putString(PROP_RANDOM_SERIAL_NUMBER_COUNTER, this.mCounter.toString() + "," + t);
                } else {
                    this.mCounter = BI_MINUS_ONE;
                    this.mDBConfig.putString(PROP_RANDOM_SERIAL_NUMBER_COUNTER, this.mCounter.toString());
                }
            }
            try {
                cs.commit(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private BigInteger getRandomNumber() throws EBaseException {
        this.initCache();
        if (this.mRangeSize == null) {
            this.mRangeSize = this.mMaxSerialNo.subtract(this.mMinSerialNo).add(BigInteger.ONE);
            logger.debug("CertificateRepository: getRandomNumber  mRangeSize=" + this.mRangeSize);
            this.mBitLength = this.mRangeSize.bitLength();
            logger.debug("CertificateRepository: getRandomNumber  mBitLength=" + this.mBitLength + " >mMinRandomBitLength=" + this.mMinRandomBitLength);
        }
        if (this.mBitLength < this.mMinRandomBitLength) {
            logger.debug("CertificateRepository: getRandomNumber  mBitLength=" + this.mBitLength + " <mMinRandomBitLength=" + this.mMinRandomBitLength);
            logger.debug("CertificateRepository: getRandomNumber:  Range size is too small to support random certificate serial numbers.");
            throw new EBaseException("Range size is too small to support random certificate serial numbers.");
        }
        BigInteger randomNumber = new BigInteger(this.mBitLength, this.secureRandom);
        randomNumber = randomNumber.multiply(this.mRangeSize).shiftRight(this.mBitLength);
        logger.debug("CertificateRepository: getRandomNumber  randomNumber=" + randomNumber);
        return randomNumber;
    }

    private BigInteger getRandomSerialNumber(BigInteger randomNumber) throws EBaseException {
        BigInteger nextSerialNumber = null;
        nextSerialNumber = randomNumber.add(this.mMinSerialNo);
        logger.debug("CertificateRepository: getRandomSerialNumber  nextSerialNumber=" + nextSerialNumber);
        return nextSerialNumber;
    }

    private BigInteger checkSerialNumbers(BigInteger randomNumber, BigInteger serialNumber) throws EBaseException {
        BigInteger nextSerialNumber = null;
        BigInteger initialRandomNumber = randomNumber;
        BigInteger delta = BigInteger.ZERO;
        int i = 0;
        int n = this.mMaxCollisionRecoverySteps;
        do {
            logger.debug("CertificateRepository: checkSerialNumbers  checking(" + (i + 1) + ")=" + serialNumber);
            try {
                if (this.readCertificateRecord(serialNumber) != null) {
                    logger.debug("CertificateRepository: checkSerialNumbers  collision detected for serialNumber=" + serialNumber);
                }
            }
            catch (EDBRecordNotFoundException nfe) {
                logger.debug("CertificateRepository: checkSerialNumbers  serial number " + serialNumber + " is available");
                nextSerialNumber = serialNumber;
            }
            catch (Exception e) {
                logger.warn("CertificateRepository: checkSerialNumbers: " + e.getMessage(), (Throwable)e);
            }
            if (nextSerialNumber != null) continue;
            if (i % 2 == 0) {
                delta = delta.add(BigInteger.ONE);
                serialNumber = this.getRandomSerialNumber(initialRandomNumber.add(delta));
                if (this.mMaxSerialNo != null && serialNumber.compareTo(this.mMaxSerialNo) > 0) {
                    serialNumber = this.getRandomSerialNumber(initialRandomNumber.subtract(delta));
                    ++i;
                    ++n;
                }
            } else {
                serialNumber = this.getRandomSerialNumber(initialRandomNumber.subtract(delta));
                if (this.mMinSerialNo != null && serialNumber.compareTo(this.mMinSerialNo) < 0) {
                    delta = delta.add(BigInteger.ONE);
                    serialNumber = this.getRandomSerialNumber(initialRandomNumber.add(delta));
                    ++i;
                    ++n;
                }
            }
            ++i;
        } while (nextSerialNumber == null && i < n);
        return nextSerialNumber;
    }

    public synchronized BigInteger getNextSerialNumber() throws EBaseException {
        if (this.idGenerator == Repository.IDGenerator.RANDOM) {
            return super.getNextSerialNumber();
        }
        BigInteger nextSerialNumber = null;
        BigInteger randomNumber = null;
        this.initCache();
        logger.debug("CertificateRepository: getNextSerialNumber  mEnableRandomSerialNumbers=" + this.mEnableRandomSerialNumbers);
        if (this.mEnableRandomSerialNumbers) {
            int i = 0;
            do {
                if (i > 0) {
                    logger.debug("CertificateRepository: getNextSerialNumber  regenerating serial number");
                }
                randomNumber = this.getRandomNumber();
                nextSerialNumber = this.getRandomSerialNumber(randomNumber);
            } while ((nextSerialNumber = this.checkSerialNumbers(randomNumber, nextSerialNumber)) == null && ++i < this.mMaxCollisionRecoveryRegenerations);
            if (nextSerialNumber == null) {
                logger.error("CertificateRepository: in getNextSerialNumber  nextSerialNumber is null");
                throw new EBaseException("nextSerialNumber is null");
            }
            if (this.mCounter.compareTo(BigInteger.ZERO) >= 0 && this.mMinSerialNo != null && this.mMaxSerialNo != null && nextSerialNumber != null && nextSerialNumber.compareTo(this.mMinSerialNo) >= 0 && nextSerialNumber.compareTo(this.mMaxSerialNo) <= 0) {
                this.mCounter = this.mCounter.add(BigInteger.ONE);
            }
            logger.debug("CertificateRepository: getNextSerialNumber  nextSerialNumber=" + nextSerialNumber + "  mCounter=" + this.mCounter);
            super.checkRange();
        } else {
            nextSerialNumber = super.getNextSerialNumber();
        }
        return nextSerialNumber;
    }

    public BigInteger getRangeLength() {
        if (this.dbSubsystem.getEnableSerialMgmt() && this.mEnableRandomSerialNumbers) {
            return this.mMaxSerialNo.subtract(this.mMinSerialNo).add(BigInteger.ONE);
        }
        return null;
    }

    public BigInteger getRandomLimit(BigInteger rangeLength) {
        if (this.dbSubsystem.getEnableSerialMgmt() && this.mEnableRandomSerialNumbers) {
            return rangeLength.subtract(this.mLowWaterMarkNo.shiftRight(1));
        }
        return null;
    }

    public BigInteger getNumbersInRange() {
        if (this.dbSubsystem.getEnableSerialMgmt() && this.mEnableRandomSerialNumbers) {
            return this.mMaxSerialNo.subtract(this.mMinSerialNo).subtract(this.mCounter);
        }
        return super.getNumbersInRange();
    }

    public void updateCounter() {
        if (this.idGenerator == Repository.IDGenerator.RANDOM) {
            return;
        }
        logger.debug("CertificateRepository: Updating counter");
        logger.debug("CertificateRepository: - enable RSNv1: " + this.mEnableRandomSerialNumbers);
        logger.debug("CertificateRepository: - counter: " + this.mCounter);
        EngineConfig cs = this.engine.getConfig();
        try {
            this.initCache();
        }
        catch (Exception e) {
            logger.warn("CertificateRepository: updateCounter: " + e.getMessage(), (Throwable)e);
        }
        String crMode = this.dbSubsystem.getEntryAttribute(this.mBaseDN, "description", "", null);
        logger.debug("CertificateRepository: - mode: " + crMode);
        boolean modeChange = this.mEnableRandomSerialNumbers && crMode != null && crMode.equals(PROP_SEQUENTIAL_MODE) || !this.mEnableRandomSerialNumbers && crMode != null && crMode.equals(PROP_RANDOM_MODE);
        logger.debug("CertificateRepository: - mode change: " + modeChange);
        if (modeChange) {
            if (this.mForceModeChange) {
                this.setEnableRandomSerialNumbers(this.mEnableRandomSerialNumbers, true, this.mForceModeChange);
            } else {
                this.setEnableRandomSerialNumbers(!this.mEnableRandomSerialNumbers, false, this.mForceModeChange);
            }
        } else if (this.mEnableRandomSerialNumbers && this.mCounter != null && this.mCounter.compareTo(BigInteger.ZERO) >= 0) {
            long t = System.currentTimeMillis();
            this.mDBConfig.putString(PROP_RANDOM_SERIAL_NUMBER_COUNTER, this.mCounter + "," + t);
        }
        try {
            cs.commit(false);
        }
        catch (Exception e) {
            logger.warn("CertificateRepository: Unable to update CS.cfg: " + e.getMessage(), (Throwable)e);
        }
        logger.debug("CertificateRepository: - enable RSNv1: " + this.mEnableRandomSerialNumbers);
        logger.debug("CertificateRepository: - counter: " + this.mCounter);
    }

    private BigInteger getInRangeCount(String fromTime, BigInteger minSerialNo, BigInteger maxSerialNo) throws EBaseException {
        BigInteger count = BigInteger.ZERO;
        String filter = null;
        filter = fromTime != null && fromTime.length() > 0 ? "(certCreateTime >= " + fromTime + ")" : "(&(certRecordId>=" + minSerialNo + ")(certRecordId<=" + maxSerialNo + "))";
        logger.debug("CertificateRepository: getInRangeCount  filter=" + filter + "  minSerialNo=" + minSerialNo + "  maxSerialNo=" + maxSerialNo);
        Enumeration<Object> e = this.findCertRecs(filter, new String[]{"certRecordId", "objectclass"});
        while (e != null && e.hasMoreElements()) {
            CertRecord rec = (CertRecord)e.nextElement();
            if (rec == null) continue;
            BigInteger sn = rec.getSerialNumber();
            if (fromTime != null && fromTime.length() != 0 && (minSerialNo == null || maxSerialNo == null || sn == null || sn.compareTo(minSerialNo) < 0 || sn.compareTo(maxSerialNo) > 0)) continue;
            count = count.add(BigInteger.ONE);
        }
        logger.debug("CertificateRepository: getInRangeCount  count=" + count);
        return count;
    }

    private BigInteger getInRangeCounter(BigInteger minSerialNo, BigInteger maxSerialNo) throws EBaseException {
        EngineConfig cs = this.engine.getConfig();
        String c = null;
        String t = null;
        String s = this.mDBConfig.getString(PROP_RANDOM_SERIAL_NUMBER_COUNTER, "-1").trim();
        logger.debug("CertificateRepository: getInRangeCounter:  saved counter string=" + s);
        int i = s.indexOf(44);
        int n = s.length();
        if (i > -1) {
            if (i > 0) {
                c = s.substring(0, i);
                if (i < n) {
                    t = s.substring(i + 1);
                }
            } else {
                c = "-1";
            }
        } else {
            c = s;
        }
        logger.debug("CertificateRepository: getInRangeCounter:  c=" + c + "  t=" + (t != null ? t : "null"));
        BigInteger counter = new BigInteger(c);
        BigInteger count = BigInteger.ZERO;
        if (this.engine.isPreOpMode()) {
            logger.debug("CertificateRepository: getInRangeCounter:  CMS.isPreOpMode");
            counter = new BigInteger("-2");
            this.mDBConfig.putString(PROP_RANDOM_SERIAL_NUMBER_COUNTER, "-2");
            try {
                cs.commit(false);
            }
            catch (Exception e) {
                logger.warn("CertificateRepository: getInRangeCounter: " + e.getMessage(), (Throwable)e);
            }
        } else if (t != null) {
            count = this.getInRangeCount(t, minSerialNo, maxSerialNo);
            if (count.compareTo(BigInteger.ZERO) > 0) {
                counter = counter.add(count);
            }
        } else if (s.equals("-2") && (count = this.getInRangeCount(t, minSerialNo, maxSerialNo)).compareTo(BigInteger.ZERO) >= 0) {
            counter = count;
        }
        logger.debug("CertificateRepository: getInRangeCounter:  counter=" + counter);
        return counter;
    }

    public BigInteger getLastSerialNumberInRange(BigInteger serial_low_bound, BigInteger serial_upper_bound) throws EBaseException {
        logger.debug("CertificateRepository:  in getLastSerialNumberInRange: low " + serial_low_bound + " high " + serial_upper_bound);
        if (serial_low_bound == null || serial_upper_bound == null || serial_low_bound.compareTo(serial_upper_bound) >= 0) {
            return null;
        }
        EngineConfig cs = this.engine.getConfig();
        this.mEnableRandomSerialNumbers = this.mDBConfig.getBoolean(PROP_ENABLE_RANDOM_SERIAL_NUMBERS, false);
        this.mForceModeChange = this.mDBConfig.getBoolean(PROP_FORCE_MODE_CHANGE, false);
        String crMode = this.dbSubsystem.getEntryAttribute(this.mBaseDN, "description", "", null);
        this.mMinRandomBitLength = this.mDBConfig.getInteger(PROP_MINIMUM_RANDOM_BITS, 4);
        this.mMaxCollisionRecoverySteps = this.mDBConfig.getInteger(PROP_COLLISION_RECOVERY_STEPS, 10);
        this.mMaxCollisionRecoveryRegenerations = this.mDBConfig.getInteger(PROP_COLLISION_RECOVERY_REGENERATIONS, 3);
        boolean modeChange = this.mEnableRandomSerialNumbers && crMode != null && crMode.equals(PROP_SEQUENTIAL_MODE) || !this.mEnableRandomSerialNumbers && crMode != null && crMode.equals(PROP_RANDOM_MODE);
        boolean enableRsnAtConfig = this.mEnableRandomSerialNumbers && this.engine.isPreOpMode() && (crMode == null || crMode.length() == 0);
        logger.debug("CertificateRepository: getLastSerialNumberInRange  mEnableRandomSerialNumbers=" + this.mEnableRandomSerialNumbers + "  mMinRandomBitLength=" + this.mMinRandomBitLength + "  CollisionRecovery=" + this.mMaxCollisionRecoveryRegenerations + "," + this.mMaxCollisionRecoverySteps);
        logger.debug("CertificateRepository: getLastSerialNumberInRange  modeChange=" + modeChange + "  enableRsnAtConfig=" + enableRsnAtConfig + "  mForceModeChange=" + this.mForceModeChange + (String)(crMode != null ? "  mode=" + crMode : ""));
        if (modeChange || enableRsnAtConfig) {
            if (this.mForceModeChange || enableRsnAtConfig) {
                this.setCertificateRepositoryMode(this.mEnableRandomSerialNumbers ? PROP_RANDOM_MODE : PROP_SEQUENTIAL_MODE);
                if (this.mForceModeChange) {
                    this.mForceModeChange = false;
                    this.mDBConfig.remove(PROP_FORCE_MODE_CHANGE);
                }
            } else {
                this.mEnableRandomSerialNumbers = !this.mEnableRandomSerialNumbers;
                this.mDBConfig.putBoolean(PROP_ENABLE_RANDOM_SERIAL_NUMBERS, this.mEnableRandomSerialNumbers);
            }
        }
        this.mCounter = this.mEnableRandomSerialNumbers && this.mCounter == null ? this.getInRangeCounter(serial_low_bound, serial_upper_bound) : BI_MINUS_ONE;
        this.mDBConfig.putString(PROP_RANDOM_SERIAL_NUMBER_COUNTER, this.mCounter.toString());
        try {
            cs.commit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("CertificateRepository: getLastSerialNumberInRange  mEnableRandomSerialNumbers=" + this.mEnableRandomSerialNumbers);
        String ldapfilter = "(certStatus=*)";
        String[] attrs = null;
        CertRecordList recList = this.findCertRecordsInList(ldapfilter, attrs, serial_upper_bound.toString(10), "serialno", -5);
        int size = recList.getSize();
        logger.debug("CertificateRepository:getLastSerialNumberInRange: recList size " + size);
        if (size <= 0) {
            logger.debug("CertificateRepository:getLastSerialNumberInRange: index may be empty");
            BigInteger ret = new BigInteger(serial_low_bound.toString(10));
            ret = ret.subtract(BigInteger.ONE);
            logger.debug("CertificateRepository:getLastCertRecordSerialNo: returning " + ret);
            return ret;
        }
        int ltSize = recList.getSizeBeforeJumpTo();
        logger.debug("CertificateRepository:getLastSerialNumberInRange: ltSize " + ltSize);
        CertRecord curRec = null;
        CertRecord obj = null;
        for (int i = 0; i < 5; ++i) {
            obj = recList.getCertRecord(i);
            if (obj != null) {
                curRec = obj;
                BigInteger serial = curRec.getSerialNumber();
                logger.debug("CertificateRepository:getLastCertRecordSerialNo:  serialno  " + serial);
                if (serial.compareTo(serial_low_bound) != 0 && serial.compareTo(serial_low_bound) != 1 || serial.compareTo(serial_upper_bound) != 0 && serial.compareTo(serial_upper_bound) != -1) continue;
                logger.debug("getLastSerialNumberInRange returning: " + serial);
                if (modeChange && this.mEnableRandomSerialNumbers) {
                    this.mCounter = serial.subtract(serial_low_bound).add(BigInteger.ONE);
                    logger.debug("getLastSerialNumberInRange mCounter: " + this.mCounter);
                }
                return serial;
            }
            logger.warn("getLastSerialNumberInRange:found null from getCertRecord");
        }
        BigInteger ret = new BigInteger(serial_low_bound.toString(10));
        ret = ret.subtract(BigInteger.ONE);
        logger.debug("CertificateRepository:getLastCertRecordSerialNo: returning " + ret);
        if (modeChange && this.mEnableRandomSerialNumbers) {
            this.mCounter = BigInteger.ZERO;
            logger.debug("getLastSerialNumberInRange mCounter: " + this.mCounter);
        }
        return ret;
    }

    public void removeCertRecords(BigInteger beginS, BigInteger endS) throws EBaseException {
        String filter = "(certStatus=*)";
        CertRecordList list = this.findCertRecordsInList(filter, null, "serialno", 10);
        int size = list.getSize();
        Enumeration e = list.getCertRecords(0, size - 1);
        while (e.hasMoreElements()) {
            CertRecord rec = (CertRecord)e.nextElement();
            BigInteger cur = rec.getSerialNumber();
            BigInteger max = cur.max(beginS);
            BigInteger min = cur;
            if (endS != null) {
                min = cur.min(endS);
            }
            if (!cur.equals(beginS) && !cur.equals(endS) && (!cur.equals(max) || !cur.equals(min))) continue;
            this.deleteCertificateRecord(cur);
        }
    }

    public void setConsistencyCheck(boolean ConsistencyCheck) {
        this.mConsistencyCheck = ConsistencyCheck;
    }

    public CertRecord createCertRecord(RequestId requestID, String profileIDMapping, X509CertImpl cert) throws Exception {
        CertId certID = new CertId(cert.getSerialNumber());
        MetaInfo meta = new MetaInfo();
        meta.set("requestId", (Object)requestID.toString());
        meta.set("profileId", (Object)profileIDMapping);
        return new CertRecord(cert.getSerialNumber(), (Certificate)cert, meta);
    }

    public void addCertificateRecord(CertRecord record) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + record.getSerialNumber() + "," + this.mBaseDN;
            logger.debug("CertificateRepository: Adding certificate record " + name);
            X509CertImpl x509cert = (X509CertImpl)record.get("x509cert");
            logger.debug("CertificateRepository: - subject: " + x509cert.getSubjectName());
            logger.debug("CertificateRepository: - issuer: " + x509cert.getIssuerName());
            SessionContext ctx = SessionContext.getContext();
            String uid = (String)ctx.get((Object)"userid");
            if (uid == null) {
                uid = "system";
            }
            record.set("certIssuedBy", (Object)uid);
            logger.debug("CertificateRepository: - issued by: " + uid);
            Date now = new Date();
            String status = (String)record.get("certStatus");
            if (x509cert.getNotBefore().after(now)) {
                status = "INVALID";
                record.set("certStatus", (Object)status);
            }
            logger.debug("CertificateRepository: - status: " + status);
            s.add(name, (IDBObj)record);
        }
        catch (EBaseException e) {
            throw new EBaseException("Unable to add certificate record: " + e.getMessage(), (Throwable)e);
        }
    }

    public void addRevokedCertRecord(CertRecord record) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + record.getSerialNumber() + "," + this.mBaseDN;
            s.add(name, (IDBObj)record);
        }
    }

    public void updateStatus(Vector<CertId> list, String status) throws EBaseException {
        for (int i = 0; i < list.size(); ++i) {
            CertId certID = list.elementAt(i);
            this.updateStatus(certID, status);
        }
    }

    public X509CertImpl getX509Certificate(BigInteger serialNo) throws EBaseException {
        CertRecord cr = this.readCertificateRecord(serialNo);
        return cr.getCertificate();
    }

    public void deleteCertificateRecord(BigInteger serialNo) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + serialNo + "," + this.mBaseDN;
            s.delete(name);
        }
    }

    public CertRecord readCertificateRecord(BigInteger serialNo) throws EBaseException {
        CertRecord rec = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + serialNo + "," + this.mBaseDN;
            rec = (CertRecord)s.read(name);
        }
        return rec;
    }

    public boolean checkCertificateRecord(BigInteger serialNo) throws EBaseException {
        CertRecord rec = null;
        boolean exists = true;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + serialNo + "," + this.mBaseDN;
            String[] attrs = new String[]{"DN"};
            rec = (CertRecord)s.read(name, attrs);
            if (rec == null) {
                exists = false;
            }
        }
        catch (EDBRecordNotFoundException e) {
            exists = false;
        }
        catch (Exception e) {
            throw new EBaseException(e.getMessage());
        }
        return exists;
    }

    private void setCertificateRepositoryMode(String mode) {
        DBSSession s = null;
        logger.debug("CertificateRepository: setCertificateRepositoryMode   setting mode: " + mode);
        try {
            s = this.dbSubsystem.createSession();
            ModificationSet mods = new ModificationSet();
            mods.add("description", 2, (Object)mode);
            s.modify(this.mBaseDN, mods);
        }
        catch (Exception e) {
            logger.warn("CertificateRepository: setCertificateRepositoryMode: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Exception e) {
            logger.warn("CertificateRepository: setCertificateRepositoryMode: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void modifyCertificateRecord(BigInteger serialNo, ModificationSet mods) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + serialNo + "," + this.mBaseDN;
            mods.add("certModifyTime", 2, (Object)new Date());
            s.modify(name, mods);
        }
    }

    public boolean containsCertificate(BigInteger serialNo) throws EBaseException {
        try {
            CertRecord cr = this.readCertificateRecord(serialNo);
            if (cr != null) {
                return true;
            }
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        return false;
    }

    public void markAsRevoked(BigInteger id, RevocationInfo info) throws EBaseException {
        this.markAsRevoked(id, info, false);
    }

    public void markAsRevoked(BigInteger id, RevocationInfo info, boolean isAlreadyRevoked) throws EBaseException {
        ModificationSet mods = new ModificationSet();
        if (isAlreadyRevoked) {
            mods.add("certRevoInfo", 2, (Object)info);
        } else {
            mods.add("certRevoInfo", 0, (Object)info);
        }
        SessionContext ctx = SessionContext.getContext();
        String uid = (String)ctx.get((Object)"userid");
        if (isAlreadyRevoked) {
            if (uid == null) {
                mods.add("certRevokedBy", 2, (Object)"system");
            } else {
                mods.add("certRevokedBy", 2, (Object)uid);
            }
            mods.add("certRevokedOn", 2, (Object)new Date());
        } else {
            if (uid == null) {
                mods.add("certRevokedBy", 0, (Object)"system");
            } else {
                mods.add("certRevokedBy", 0, (Object)uid);
            }
            mods.add("certRevokedOn", 0, (Object)new Date());
            mods.add("certStatus", 2, (Object)"REVOKED");
        }
        this.modifyCertificateRecord(id, mods);
    }

    public void unmarkRevoked(BigInteger id, RevocationInfo info, Date revokedOn, String revokedBy) throws EBaseException {
        ModificationSet mods = new ModificationSet();
        mods.add("certRevoInfo", 1, (Object)info);
        mods.add("certRevokedBy", 1, (Object)revokedBy);
        mods.add("certRevokedOn", 1, (Object)revokedOn);
        mods.add("certStatus", 2, (Object)"VALID");
        this.modifyCertificateRecord(id, mods);
    }

    public void updateStatus(CertId id, String status) throws EBaseException {
        logger.info("CertificateRepository: Updating cert " + id.toHexString() + " status to " + status);
        ModificationSet mods = new ModificationSet();
        mods.add("certStatus", 2, (Object)status);
        this.modifyCertificateRecord(id.toBigInteger(), mods);
    }

    public Enumeration<Object> searchCertificates(String filter, int maxSize, String sortAttribute) throws EBaseException {
        DBSearchResults e = null;
        logger.debug("searchCertificates filter " + filter + " maxSize " + maxSize);
        try (DBSSession s = this.dbSubsystem.createSession();){
            e = s.search(this.mBaseDN, filter, maxSize, sortAttribute);
        }
        return e;
    }

    public Enumeration<Object> searchCertificates(String filter, int maxSize) throws EBaseException {
        DBSearchResults e = null;
        logger.debug("searchCertificates filter " + filter + " maxSize " + maxSize);
        try (DBSSession s = this.dbSubsystem.createSession();){
            e = s.search(this.mBaseDN, filter, maxSize);
        }
        return e;
    }

    public Enumeration<CertRecord> searchCertificates(String filter, int maxSize, int timeLimit) throws EBaseException {
        Vector<CertRecord> v = new Vector<CertRecord>();
        logger.debug("searchCertificateswith time limit filter " + filter);
        try (DBSSession s = this.dbSubsystem.createSession();){
            DBSearchResults sr = s.search(this.mBaseDN, filter, maxSize, timeLimit);
            while (sr.hasMoreElements()) {
                v.add((CertRecord)sr.nextElement());
            }
        }
        return v.elements();
    }

    public Enumeration<CertRecord> searchCertificates(String filter, int maxSize, int timeLimit, String sortAttribute) throws EBaseException {
        Vector<CertRecord> v = new Vector<CertRecord>();
        logger.debug("searchCertificateswith time limit filter " + filter);
        try (DBSSession s = this.dbSubsystem.createSession();){
            DBSearchResults sr = s.search(this.mBaseDN, filter, maxSize, timeLimit, sortAttribute);
            while (sr.hasMoreElements()) {
                v.add((CertRecord)sr.nextElement());
            }
        }
        return v.elements();
    }

    @Deprecated
    public Enumeration<Object> findCertRecs(String filter) throws EBaseException {
        logger.debug("findCertRecs " + filter);
        DBSearchResults e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            e = s.search(this.mBaseDN, filter);
        }
        return e;
    }

    public Enumeration<Object> findCertRecs(String filter, String[] attrs) throws EBaseException {
        logger.debug("findCertRecs " + filter + "attrs " + Arrays.toString(attrs));
        DBSearchResults e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            e = s.search(this.mBaseDN, filter, attrs);
        }
        return e;
    }

    public Enumeration<X509CertImpl> findCertificates(String filter) throws EBaseException {
        Enumeration<CertRecord> e = this.findCertRecords(filter);
        Vector<X509CertImpl> v = new Vector<X509CertImpl>();
        while (e.hasMoreElements()) {
            CertRecord rec = e.nextElement();
            v.addElement(rec.getCertificate());
        }
        return v.elements();
    }

    public Enumeration<CertRecord> findCertRecords(String filter) throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            CertRecordList list = this.findCertRecordsInList(filter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public CertRecordList findCertRecordsInList(String filter, String[] attrs, int pageSize) throws EBaseException {
        return this.findCertRecordsInList(filter, attrs, "certRecordId", pageSize);
    }

    public CertRecordList findCertRecordsInList(String filter, String[] attrs, String sortKey, int pageSize) throws EBaseException {
        logger.debug("CertificateRepository.findCertRecordsInList()");
        try (DBSSession session = this.dbSubsystem.createSession();){
            DBVirtualList list = session.createVirtualList(this.mBaseDN, filter, attrs, sortKey, pageSize);
            CertRecordList certRecordList = new CertRecordList(list);
            return certRecordList;
        }
    }

    public CertRecordList findCertRecordsInList(String filter, String[] attrs, String jumpTo, String sortKey, int pageSize) throws EBaseException {
        return this.findCertRecordsInList(filter, attrs, jumpTo, false, sortKey, pageSize);
    }

    public CertRecordList findCertRecordsInList(String filter, String[] attrs, String jumpTo, boolean hardJumpTo, String sortKey, int pageSize) throws EBaseException {
        CertRecordList list = null;
        logger.debug("In findCertRecordsInList with Jumpto " + jumpTo);
        try (DBSSession s = this.dbSubsystem.createSession();){
            Object jumpToVal = null;
            if (hardJumpTo) {
                logger.debug("In findCertRecordsInList with hardJumpto ");
                jumpToVal = "99";
            } else {
                int len = jumpTo.length();
                jumpToVal = len > 9 ? Integer.toString(len) + jumpTo : "0" + Integer.toString(len) + jumpTo;
            }
            DBVirtualList vlist = s.createVirtualList(this.mBaseDN, filter, attrs, (String)jumpToVal, sortKey, pageSize);
            list = new CertRecordList(vlist);
        }
        return list;
    }

    public CertRecordList findCertRecordsInListRawJumpto(String filter, String[] attrs, String jumpTo, String sortKey, int pageSize) throws EBaseException {
        CertRecordList list = null;
        logger.debug("In findCertRecordsInListRawJumpto with Jumpto " + jumpTo);
        try (DBSSession s = this.dbSubsystem.createSession();){
            DBVirtualList vlist = s.createVirtualList(this.mBaseDN, filter, attrs, jumpTo, sortKey, pageSize);
            list = new CertRecordList(vlist);
        }
        return list;
    }

    public void markCertificateAsRenewable(CertRecord record) throws EBaseException {
        this.changeRenewalAttribute(record.getSerialNumber().toString(), "ENABLED");
    }

    public void markCertificateAsNotRenewable(CertRecord record) throws EBaseException {
        this.changeRenewalAttribute(record.getSerialNumber().toString(), "DISABLED");
    }

    public void markCertificateAsRenewed(String serialNo) throws EBaseException {
        this.changeRenewalAttribute(serialNo, "DONE");
    }

    public void markCertificateAsRenewalNotified(String serialNo) throws EBaseException {
        this.changeRenewalAttribute(serialNo, "NOTIFIED");
    }

    private void changeRenewalAttribute(String serialno, String value) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + serialno + "," + this.mBaseDN;
            ModificationSet mods = new ModificationSet();
            mods.add("certAutoRenew", 2, (Object)value);
            s.modify(name, mods);
        }
    }

    public Hashtable<String, RenewableCertificateCollection> getRenewableCertificates(String renewalTime) throws EBaseException {
        Hashtable<String, RenewableCertificateCollection> tab = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String filter = "(&(certStatus=VALID)(x509cert.notAfter<=" + renewalTime + ")(!(certAutoRenew=DONE))(!(certAutoRenew=NOTIFIED)))";
            CertRecordList list = this.findCertRecordsInList(filter, null, "serialno", 10);
            int size = list.getSize();
            Enumeration e = list.getCertRecords(0, size - 1);
            tab = new Hashtable<String, RenewableCertificateCollection>();
            while (e.hasMoreElements()) {
                CertRecord rec = (CertRecord)e.nextElement();
                X509CertImpl cert = rec.getCertificate();
                String subjectDN = cert.getSubjectName().toString();
                String renewalFlag = rec.getAutoRenew();
                RenewableCertificateCollection val = null;
                val = tab.get(subjectDN);
                if (val == null) {
                    RenewableCertificateCollection collection = new RenewableCertificateCollection();
                    collection.addCertificate(renewalFlag, (Object)cert);
                    tab.put(subjectDN, collection);
                    continue;
                }
                val.addCertificate(renewalFlag, (Object)cert);
            }
        }
        return tab;
    }

    public X509CertImpl[] getX509Certificates(String subjectDN, int validityType) throws EBaseException {
        Object[] certs = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String filter = "(&(x509cert.subject=" + subjectDN;
            if (validityType == 1) {
                filter = filter + ")(certStatus=VALID";
            }
            if (validityType == 2) {
                filter = filter + ")(|(certStatus=VALID)(certStatus=EXPIRED)";
            }
            filter = filter + "))";
            CertRecordList list = this.findCertRecordsInList(filter, null, "serialno", 10);
            int size = list.getSize();
            Enumeration e = list.getCertRecords(0, size - 1);
            Vector<X509CertImpl> v = new Vector<X509CertImpl>();
            while (e.hasMoreElements()) {
                CertRecord rec = (CertRecord)e.nextElement();
                v.addElement(rec.getCertificate());
            }
            if (v.size() == 0) {
                X509CertImpl[] x509CertImplArray = null;
                return x509CertImplArray;
            }
            certs = new X509CertImpl[v.size()];
            v.copyInto(certs);
        }
        return certs;
    }

    public X509CertImpl[] getX509Certificates(String filter) throws EBaseException {
        Object[] certs = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Enumeration e = null;
            if (filter != null && filter.length() > 0) {
                CertRecordList list = this.findCertRecordsInList(filter, null, "serialno", 10);
                int size = list.getSize();
                e = list.getCertRecords(0, size - 1);
            }
            Vector<X509CertImpl> v = new Vector<X509CertImpl>();
            while (e != null && e.hasMoreElements()) {
                CertRecord rec = (CertRecord)e.nextElement();
                v.addElement(rec.getCertificate());
            }
            if (v.size() > 0) {
                certs = new X509CertImpl[v.size()];
                v.copyInto(certs);
            }
        }
        return certs;
    }

    public Enumeration<CertRecord> getValidCertificates(String from, String to) throws EBaseException {
        Vector<CertRecord> v = new Vector<CertRecord>();
        try (DBSSession s = this.dbSubsystem.createSession();){
            String ldapfilter = "(certstatus=VALID)";
            String fromVal = "0";
            try {
                if (from != null) {
                    new BigInteger(from);
                    fromVal = from;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            CertRecordList list = this.findCertRecordsInList(ldapfilter, null, fromVal, "serialno", 40);
            BigInteger toInt = null;
            if (to != null && !to.trim().equals("")) {
                toInt = new BigInteger(to);
            }
            int i = 0;
            while (true) {
                CertRecord rec = list.getCertRecord(i);
                logger.debug("processing record: " + i);
                if (rec == null) {
                    break;
                }
                logger.debug("processing record: " + i + " " + rec.getSerialNumber());
                if (toInt != null && rec.getSerialNumber().compareTo(toInt) > 0) {
                    break;
                }
                v.addElement(rec);
                ++i;
            }
        }
        logger.debug("returning " + v.size() + " elements");
        return v.elements();
    }

    public Enumeration<CertRecord> getAllValidCertificates() throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Date now = new Date();
            String ldapfilter = "(&(!(certRevoInfo=*))(x509cert.notBefore<=" + DateMapper.dateToDB((Date)now) + ")(x509cert.notAfter>=" + DateMapper.dateToDB((Date)now) + "))";
            CertRecordList list = this.findCertRecordsInList(ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getValidNotPublishedCertificates(String from, String to) throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Date now = new Date();
            Object ldapfilter = "(&(";
            if (from != null && from.length() > 0) {
                ldapfilter = (String)ldapfilter + "certRecordId>=" + from + ")(";
            }
            if (to != null && to.length() > 0) {
                ldapfilter = (String)ldapfilter + "certRecordId<=" + to + ")(";
            }
            ldapfilter = (String)ldapfilter + "!(certRevoInfo=*))(x509cert.notBefore<=" + DateMapper.dateToDB((Date)now) + ")(x509cert.notAfter>=" + DateMapper.dateToDB((Date)now) + ")(!(certMetainfo=inLdapPublishDir:true)))";
            CertRecordList list = this.findCertRecordsInList((String)ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getAllValidNotPublishedCertificates() throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Date now = new Date();
            String ldapfilter = "(&(!(certRevoInfo=*))(x509cert.notBefore<=" + DateMapper.dateToDB((Date)now) + ")(x509cert.notAfter>=" + DateMapper.dateToDB((Date)now) + ")(!(certMetainfo=inLdapPublishDir:true)))";
            CertRecordList list = this.findCertRecordsInList(ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getExpiredCertificates(String from, String to) throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Date now = new Date();
            Object ldapfilter = "(&(";
            if (from != null && from.length() > 0) {
                ldapfilter = (String)ldapfilter + "certRecordId>=" + from + ")(";
            }
            if (to != null && to.length() > 0) {
                ldapfilter = (String)ldapfilter + "certRecordId<=" + to + ")(";
            }
            ldapfilter = (String)ldapfilter + "!(x509cert.notAfter>=" + DateMapper.dateToDB((Date)now) + ")))";
            CertRecordList list = this.findCertRecordsInList((String)ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getAllExpiredCertificates() throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Date now = new Date();
            String ldapfilter = "(!(x509cert.notAfter>=" + DateMapper.dateToDB((Date)now) + "))";
            CertRecordList list = this.findCertRecordsInList(ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getExpiredPublishedCertificates(String from, String to) throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Date now = new Date();
            Object ldapfilter = "(&(";
            if (from != null && from.length() > 0) {
                ldapfilter = (String)ldapfilter + "certRecordId>=" + from + ")(";
            }
            if (to != null && to.length() > 0) {
                ldapfilter = (String)ldapfilter + "certRecordId<=" + to + ")(";
            }
            ldapfilter = (String)ldapfilter + "!(x509cert.notAfter>=" + DateMapper.dateToDB((Date)now) + "))(certMetainfo=inLdapPublishDir:true))";
            CertRecordList list = this.findCertRecordsInList((String)ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getAllExpiredPublishedCertificates() throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Date now = new Date();
            Object ldapfilter = "(&";
            ldapfilter = (String)ldapfilter + "(!(x509cert.notAfter>=" + DateMapper.dateToDB((Date)now) + "))";
            ldapfilter = (String)ldapfilter + "(certMetainfo=inLdapPublishDir:true))";
            CertRecordList list = this.findCertRecordsInList((String)ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public CertRecordList getInvalidCertsByNotBeforeDate(Date date, int pageSize) throws EBaseException {
        CertRecordList list = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String ldapfilter = "(certStatus=INVALID)";
            String[] attrs = null;
            if (!this.mConsistencyCheck) {
                attrs = new String[]{"objectclass", "certRecordId", "x509cert"};
            }
            logger.debug("getInvalidCertificatesByNotBeforeDate filter " + ldapfilter);
            logger.debug("getInvalidCertificatesByNotBeforeDate: about to call findCertRecordsInList");
            list = this.findCertRecordsInListRawJumpto(ldapfilter, attrs, DateMapper.dateToDB((Date)date), "notBefore", pageSize);
        }
        return list;
    }

    public CertRecordList getValidCertsByNotAfterDate(Date date, int pageSize) throws EBaseException {
        CertRecordList list = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String ldapfilter = "(certStatus=VALID)";
            String[] attrs = null;
            if (!this.mConsistencyCheck) {
                attrs = new String[]{"objectclass", "certRecordId", "x509cert"};
            }
            logger.debug("getValidCertsByNotAfterDate filter " + ldapfilter);
            list = this.findCertRecordsInListRawJumpto(ldapfilter, attrs, DateMapper.dateToDB((Date)date), "notAfter", pageSize);
        }
        return list;
    }

    public CertRecordList getRevokedCertsByNotAfterDate(Date date, int pageSize) throws EBaseException {
        CertRecordList list = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String ldapfilter = "(certStatus=REVOKED)";
            String[] attrs = null;
            if (!this.mConsistencyCheck) {
                attrs = new String[]{"objectclass", "certRevokedOn", "certRecordId", "certRevoInfo", "notAfter", "x509cert"};
            }
            logger.debug("getRevokedCertificatesByNotAfterDate filter " + ldapfilter);
            logger.debug("getRevokedCertificatesByNotAfterDate: about to call findCertRecordsInList");
            list = this.findCertRecordsInListRawJumpto(ldapfilter, attrs, DateMapper.dateToDB((Date)date), "notafter", pageSize);
        }
        return list;
    }

    public Enumeration<CertRecord> getRevokedCertificates(String from, String to) throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Object ldapfilter = "(&(certRevoInfo=*)";
            if (from != null && from.length() > 0) {
                ldapfilter = (String)ldapfilter + "(certRecordId>=" + from + ")";
            }
            if (to != null && to.length() > 0) {
                ldapfilter = (String)ldapfilter + "(certRecordId<=" + to + ")";
            }
            ldapfilter = (String)ldapfilter + ")";
            CertRecordList list = this.findCertRecordsInList((String)ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getAllRevokedCertificates() throws EBaseException {
        Enumeration e = null;
        String ldapfilter = "(|(certStatus=REVOKED)(certStatus=REVOKED_EXPIRED))";
        try (DBSSession s = this.dbSubsystem.createSession();){
            CertRecordList list = this.findCertRecordsInList(ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getRevokedPublishedCertificates(String from, String to) throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            Object ldapfilter = "(&(certRevoInfo=*)";
            if (from != null && from.length() > 0) {
                ldapfilter = (String)ldapfilter + "(certRecordId>=" + from + ")";
            }
            if (to != null && to.length() > 0) {
                ldapfilter = (String)ldapfilter + "(certRecordId<=" + to + ")";
            }
            ldapfilter = (String)ldapfilter + "(certMetainfo=inLdapPublishDir:true))";
            CertRecordList list = this.findCertRecordsInList((String)ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getAllRevokedPublishedCertificates() throws EBaseException {
        Enumeration e = null;
        Object ldapfilter = "(&(|(certStatus=REVOKED)(certStatus=REVOKED_EXPIRED))";
        ldapfilter = (String)ldapfilter + "(certMetainfo=inLdapPublishDir:true))";
        try (DBSSession s = this.dbSubsystem.createSession();){
            CertRecordList list = this.findCertRecordsInList((String)ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getRevokedCertificates(Date asOfDate) throws EBaseException {
        Enumeration e = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String ldapfilter = "(&(certRevoInfo=*)(x509cert.notAfter >= " + DateMapper.dateToDB((Date)asOfDate) + "))";
            CertRecordList list = this.findCertRecordsInList(ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    public Enumeration<CertRecord> getAllRevokedNonExpiredCertificates() throws EBaseException {
        Enumeration e = null;
        String ldapfilter = "(certStatus=REVOKED)";
        try (DBSSession s = this.dbSubsystem.createSession();){
            CertRecordList list = this.findCertRecordsInList(ldapfilter, null, "serialno", 10);
            int size = list.getSize();
            e = list.getCertRecords(0, size - 1);
        }
        return e;
    }

    LDAPSearchResults searchForModifiedCertificateRecords(DBSSession session) throws EBaseException {
        logger.debug("Starting persistent search.");
        String filter = "(certStatus=*)";
        return session.persistentSearch(this.mBaseDN, filter, null);
    }

    public RevocationInfo isCertificateRevoked(X509CertImpl cert) throws EBaseException {
        X500Name repCertName;
        if (cert == null) {
            logger.warn("CertificateRepository: Missing certificate");
            return null;
        }
        logger.debug("CertificateRepository: Checking revocation status for cert " + cert.getSerialNumber());
        CertRecord rec = this.readCertificateRecord(cert.getSerialNumber());
        if (rec == null) {
            logger.debug("CertificateRepository: Unknown certificate");
            return null;
        }
        if (!rec.getStatus().equals("REVOKED")) {
            logger.debug("CertificateRepository: Certificate not revoked");
            return null;
        }
        X500Name name = cert.getSubjectName();
        if (!name.equals((Object)(repCertName = rec.getCertificate().getSubjectName()))) {
            logger.debug("CertificateRepository: Certificate subjects do not match");
            return null;
        }
        byte[] certEncoded = null;
        byte[] repCertEncoded = null;
        try {
            certEncoded = cert.getEncoded();
            repCertEncoded = rec.getCertificate().getEncoded();
        }
        catch (Exception e) {
            logger.warn("Unable to parse certificate: " + e.getMessage(), (Throwable)e);
        }
        if (certEncoded == null || repCertEncoded == null) {
            return null;
        }
        if (certEncoded.length != repCertEncoded.length) {
            logger.debug("CertificateRepository: Certificate lengths do not match");
            return null;
        }
        for (int i = 0; i < certEncoded.length; ++i) {
            if (certEncoded[i] == repCertEncoded[i]) continue;
            logger.debug("CertificateRepository: Certificate data do not match");
            return null;
        }
        RevocationInfo info = rec.getRevocationInfo();
        logger.debug("CertificateRepository: - revocation date: " + info.getRevocationDate());
        return info;
    }

    public void shutdown() {
    }
}

