/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authority.AuthorityData;
import com.netscape.certsrv.authority.AuthorityResource;
import com.netscape.certsrv.base.BadRequestDataException;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ConflictingOperationException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.base.ServiceUnavailableException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CADisabledException;
import com.netscape.certsrv.ca.CAEnabledException;
import com.netscape.certsrv.ca.CAMissingCertException;
import com.netscape.certsrv.ca.CAMissingKeyException;
import com.netscape.certsrv.ca.CANotFoundException;
import com.netscape.certsrv.ca.CANotLeafException;
import com.netscape.certsrv.ca.CATypeException;
import com.netscape.certsrv.ca.IssuerUnavailableException;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityService
extends SubsystemService
implements AuthorityResource {
    public static Logger logger = LoggerFactory.getLogger(AuthorityService.class);
    CertificateAuthority hostCA;

    public AuthorityService() {
        CAEngine engine = CAEngine.getInstance();
        this.hostCA = engine.getCA();
    }

    public Response findCAs(String id, String parentID, String dn, String issuerDN) throws Exception {
        logger.info("AuthorityService: getting authorities:");
        X500Name x500dn = dn == null ? null : new X500Name(dn);
        X500Name x500issuerDN = issuerDN == null ? null : new X500Name(issuerDN);
        ArrayList<AuthorityData> results = new ArrayList<AuthorityData>();
        CAEngine engine = CAEngine.getInstance();
        for (CertificateAuthority ca : engine.getCAs()) {
            X500Name caIssuerDN;
            X500Name caDN;
            AuthorityData authority = AuthorityService.readAuthorityData(ca);
            if (id != null && !id.equalsIgnoreCase(authority.getID()) || parentID != null && !parentID.equalsIgnoreCase(authority.getParentID()) || x500dn != null && !x500dn.equals((Object)(caDN = new X500Name(authority.getDN()))) || x500issuerDN != null && !x500issuerDN.equals((Object)(caIssuerDN = new X500Name(authority.getIssuerDN())))) continue;
            logger.info("AuthorityService: - ID: " + authority.getID());
            logger.info("AuthorityService:   DN: " + authority.getDN());
            if (authority.getParentID() != null) {
                logger.info("AuthorityService:   Parent ID: " + authority.getParentID());
            }
            logger.info("AuthorityService:   Issuer DN: " + authority.getIssuerDN());
            results.add(authority);
        }
        GenericEntity<List<AuthorityData>> entity = new GenericEntity<List<AuthorityData>>(results){};
        return this.createOKResponse(entity);
    }

    public Response getCA(String aidString) {
        logger.info("AuthorityService: getting authority " + aidString + ":");
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        if (!"host-authority".equals(aidString)) {
            AuthorityID aid;
            try {
                aid = new AuthorityID(aidString);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Bad AuthorityID: " + aidString);
            }
            ca = engine.getCA(aid);
            if (ca == null) {
                throw new ResourceNotFoundException("CA \"" + aidString + "\" not found");
            }
        }
        AuthorityData authority = AuthorityService.readAuthorityData(ca);
        logger.info("AuthorityService:   DN: " + authority.getDN());
        if (authority.getParentID() != null) {
            logger.info("AuthorityService:   Parent ID: " + authority.getParentID());
        }
        logger.info("AuthorityService:   Issuer DN: " + authority.getIssuerDN());
        return this.createOKResponse(authority);
    }

    public Response getCert(String aidString) {
        CAEngine engine;
        CertificateAuthority ca;
        logger.info("AuthorityService: getting cert for authority " + aidString);
        AuthorityID aid = null;
        if (!"host-authority".equals(aidString)) {
            try {
                aid = new AuthorityID(aidString);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Bad AuthorityID: " + aidString);
            }
        }
        if ((ca = (engine = CAEngine.getInstance()).getCA(aid)) == null) {
            throw new ResourceNotFoundException("CA \"" + aidString + "\" not found");
        }
        X509Certificate cert = ca.getCaX509Cert();
        if (cert == null) {
            throw new ResourceNotFoundException("Certificate for CA \"" + aidString + "\" not available");
        }
        try {
            return Response.ok((Object)cert.getEncoded()).build();
        }
        catch (CertificateEncodingException e) {
            throw new PKIException("Error encoding certificate: " + e);
        }
    }

    public Response getCertPEM(String aidString) {
        byte[] der = (byte[])this.getCert(aidString).getEntity();
        return Response.ok((Object)this.toPem("CERTIFICATE", der)).build();
    }

    public Response getChain(String aidString) {
        CAEngine engine;
        CertificateAuthority ca;
        logger.info("AuthorityService: getting cert chain for authority " + aidString);
        AuthorityID aid = null;
        if (!"host-authority".equals(aidString)) {
            try {
                aid = new AuthorityID(aidString);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Bad AuthorityID: " + aidString);
            }
        }
        if ((ca = (engine = CAEngine.getInstance()).getCA(aid)) == null) {
            throw new ResourceNotFoundException("CA \"" + aidString + "\" not found");
        }
        CertificateChain chain = ca.getCACertChain();
        if (chain == null) {
            throw new ResourceNotFoundException("Certificate chain for CA \"" + aidString + "\" not available");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            chain.encode((OutputStream)out);
        }
        catch (IOException e) {
            throw new PKIException("Error encoding certificate chain: " + e);
        }
        return Response.ok((Object)out.toByteArray()).build();
    }

    public Response getChainPEM(String aidString) {
        byte[] der = (byte[])this.getChain(aidString).getEntity();
        return Response.ok((Object)this.toPem("PKCS7", der)).build();
    }

    public Response createCA(AuthorityData data) {
        logger.info("AuthorityService: creating authority " + data.getDN());
        String parentAIDString = data.getParentID();
        AuthorityID parentAID = null;
        if ("host-authority".equals(parentAIDString)) {
            parentAID = this.hostCA.getAuthorityID();
        } else {
            try {
                parentAID = new AuthorityID(parentAIDString);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Bad Authority ID: " + parentAIDString, (Throwable)e);
            }
        }
        LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
        auditParams.put("dn", data.getDN());
        if (parentAID != null) {
            auditParams.put("parent", parentAIDString);
        }
        if (data.getDescription() != null) {
            auditParams.put("description", data.getDescription());
        }
        AuthToken authToken = (AuthToken)SessionContext.getContext().get((Object)"AuthToken");
        try {
            CAEngine engine = CAEngine.getInstance();
            CertificateAuthority subCA = engine.createCA(parentAID, authToken, data.getDN(), data.getDescription());
            this.audit("Success", "OP_ADD", subCA.getAuthorityID().toString(), auditParams);
            return this.createOKResponse(AuthorityService.readAuthorityData(subCA));
        }
        catch (BadRequestDataException | IllegalArgumentException e) {
            throw new BadRequestException(e.toString());
        }
        catch (CANotFoundException e) {
            throw new ResourceNotFoundException(e.toString());
        }
        catch (CADisabledException | IssuerUnavailableException e) {
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_ADD", "<unknown>", auditParams);
            throw new ConflictingOperationException(e.toString());
        }
        catch (CAMissingCertException | CAMissingKeyException e) {
            throw new ServiceUnavailableException(e.toString());
        }
        catch (Exception e) {
            String message = "Error creating CA: " + e.getMessage();
            logger.error(message, (Throwable)e);
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_ADD", "<unknown>", auditParams);
            throw new PKIException(message, (Throwable)e);
        }
    }

    public Response modifyCA(String aidString, AuthorityData data) {
        logger.info("AuthorityService: modifying authority " + aidString);
        AuthorityID aid = null;
        try {
            aid = new AuthorityID(aidString);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Bad AuthorityID: " + aidString);
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA(aid);
        if (ca == null) {
            throw new ResourceNotFoundException("CA \"" + aidString + "\" not found");
        }
        LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
        if (data.getEnabled().booleanValue() != ca.getAuthorityEnabled()) {
            logger.info("AuthorityService:   enabled: " + data.getEnabled());
            auditParams.put("enabled", data.getEnabled().toString());
        }
        String curDesc = ca.getAuthorityDescription();
        String newDesc = data.getDescription();
        if (curDesc != null && !curDesc.equals(newDesc) || curDesc == null && newDesc != null) {
            logger.info("AuthorityService:   description: " + data.getDescription());
            auditParams.put("description", data.getDescription());
        }
        try {
            engine.modifyAuthority(ca, data.getEnabled(), data.getDescription());
            this.audit("Success", "OP_MODIFY", ca.getAuthorityID().toString(), auditParams);
            return this.createOKResponse(AuthorityService.readAuthorityData(ca));
        }
        catch (CATypeException e) {
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_MODIFY", ca.getAuthorityID().toString(), auditParams);
            throw new ForbiddenException(e.toString());
        }
        catch (IssuerUnavailableException e) {
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_MODIFY", ca.getAuthorityID().toString(), auditParams);
            throw new ConflictingOperationException(e.toString());
        }
        catch (EBaseException e) {
            String message = "Error modifying authority: " + e.getMessage();
            logger.error(message, (Throwable)e);
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_MODIFY", ca.getAuthorityID().toString(), auditParams);
            throw new PKIException(message, (Throwable)e);
        }
    }

    public Response enableCA(String aidString) {
        return this.modifyCA(aidString, new AuthorityData(null, null, null, null, null, null, Boolean.valueOf(true), null, null));
    }

    public Response disableCA(String aidString) {
        return this.modifyCA(aidString, new AuthorityData(null, null, null, null, null, null, Boolean.valueOf(false), null, null));
    }

    public Response renewCA(String aidString) {
        logger.info("AuthorityService: renewing cert for authority " + aidString);
        AuthorityID aid = null;
        try {
            aid = new AuthorityID(aidString);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Bad AuthorityID: " + aidString);
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA(aid);
        if (ca == null) {
            throw new ResourceNotFoundException("CA \"" + aidString + "\" not found");
        }
        LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
        try {
            ca.renewAuthority(this.servletRequest);
            this.audit("Success", "OP_MODIFY", aidString, null);
            return this.createNoContentResponse();
        }
        catch (CADisabledException e) {
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_MODIFY", aidString, auditParams);
            throw new ConflictingOperationException(e.toString());
        }
        catch (Exception e) {
            String message = "Error renewing authority: " + e.getMessage();
            logger.error(message, (Throwable)e);
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_MODIFY", aidString, auditParams);
            throw new PKIException(message, (Throwable)e);
        }
    }

    public Response deleteCA(String aidString) {
        logger.info("AuthorityService: deleting authority " + aidString);
        AuthorityID aid = null;
        try {
            aid = new AuthorityID(aidString);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Bad AuthorityID: " + aidString);
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA(aid);
        if (ca == null) {
            throw new ResourceNotFoundException("CA \"" + aidString + "\" not found");
        }
        LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
        try {
            ca.deleteAuthority(this.servletRequest);
            this.audit("Success", "OP_DELETE", aidString, null);
            return this.createNoContentResponse();
        }
        catch (CATypeException e) {
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_DELETE", aidString, auditParams);
            throw new ForbiddenException(e.toString());
        }
        catch (CAEnabledException | CANotLeafException e) {
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_DELETE", aidString, auditParams);
            throw new ConflictingOperationException(e.toString());
        }
        catch (EBaseException e) {
            String message = "Error modifying authority: " + e.getMessage();
            logger.error(message, (Throwable)e);
            auditParams.put("exception", e.toString());
            this.audit("Failure", "OP_DELETE", aidString, auditParams);
            throw new PKIException(message, (Throwable)e);
        }
    }

    private static AuthorityData readAuthorityData(CertificateAuthority ca) throws PKIException {
        BigInteger serial;
        String issuerDN;
        String dn;
        try {
            dn = ca.getX500Name().toLdapDNString();
        }
        catch (IOException e) {
            throw new PKIException("Error reading CA data: could not determine subject DN");
        }
        try {
            issuerDN = ca.getCACert().getIssuerName().toString();
            serial = ca.getCACert().getSerialNumber();
        }
        catch (EBaseException e) {
            throw new PKIException("Error reading CA data: missing CA cert", (Throwable)e);
        }
        AuthorityID parentAID = ca.getAuthorityParentID();
        return new AuthorityData(Boolean.valueOf(ca.isHostAuthority()), dn, ca.getAuthorityID().toString(), parentAID != null ? parentAID.toString() : null, issuerDN, serial, Boolean.valueOf(ca.getAuthorityEnabled()), ca.getAuthorityDescription(), Boolean.valueOf(ca.isReady()));
    }

    private String toPem(String name, byte[] data) {
        return "-----BEGIN " + name + "-----\n" + Utils.base64encode((byte[])data, (boolean)true) + "-----END " + name + "-----\n";
    }

    private void audit(String status, String op, String id, Map<String, String> params) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_AUTHORITY_CONFIG_3", (Object[])new Object[]{auditor.getSubjectID(), status, auditor.getParamString("authority", op, id, params)});
        auditor.log(msg);
    }
}

