/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.OCSPAddCARequestEvent;
import com.netscape.certsrv.logging.event.OCSPAddCARequestProcessedEvent;
import com.netscape.certsrv.ocsp.IDefStore;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.ocsp.OCSPAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ocsp.OCSPEngine;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddCAServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(AddCAServlet.class);
    private static final long serialVersionUID = 1065151608542115340L;
    public static final BigInteger BIG_ZERO = new BigInteger("0");
    public static final Long MINUS_ONE = -1L;
    private static final String TPL_FILE = "addCA.template";
    private String mFormPath = null;
    private OCSPAuthority mOCSPAuthority;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/ocsp/addCA.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        OCSPEngine engine = OCSPEngine.getInstance();
        this.mOCSPAuthority = engine.getOCSP();
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        String b64;
        String uid;
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditCA = "<null>";
        String auditCASubjectDN = "<null>";
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "add");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]));
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        if ((auditSubjectID.equals("$NonRoleUser$") || auditSubjectID.equals("$Unidentified$")) && (uid = authToken.getInString("userid")) != null) {
            logger.debug("AddCAServlet: auditSubjectID set to " + uid);
            auditSubjectID = uid;
        }
        if ((b64 = cmsReq.getHttpReq().getParameter("cert")) == null) {
            auditor.log((LogEvent)OCSPAddCARequestEvent.createFailureEvent((String)auditSubjectID));
            throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_GW_MISSING_CA_CERT", (String[])new String[0]));
        }
        auditCA = Cert.normalizeCertStr((String)Cert.stripCertBrackets((String)b64.trim()));
        auditor.log((LogEvent)OCSPAddCARequestEvent.createSuccessEvent((String)auditSubjectID, (String)auditCA));
        if (b64.indexOf("-----BEGIN CERTIFICATE-----") == -1) {
            auditor.log((LogEvent)OCSPAddCARequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditCASubjectDN));
            throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_GW_MISSING_CERT_HEADER", (String[])new String[0]));
        }
        if (b64.indexOf("-----END CERTIFICATE-----") == -1) {
            auditor.log((LogEvent)OCSPAddCARequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditCASubjectDN));
            throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_GW_MISSING_CERT_FOOTER", (String[])new String[0]));
        }
        IDefStore defStore = this.mOCSPAuthority.getDefaultStore();
        X509Certificate leafCert = null;
        X509Certificate[] certs = null;
        try {
            X509CertImpl cert = Cert.mapCert((String)b64);
            if (cert == null) {
                logger.warn("AddCAServlet::process() - cert is null!");
                auditor.log((LogEvent)OCSPAddCARequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditCASubjectDN));
                throw new EBaseException("cert is null");
            }
            certs = new X509Certificate[]{cert};
            leafCert = cert;
            auditCASubjectDN = leafCert.getSubjectDN().getName();
        }
        catch (Exception cert) {
            // empty catch block
        }
        if (certs == null) {
            try {
                certs = Cert.mapCertFromPKCS7((String)b64);
                leafCert = certs[0].getSubjectDN().getName().equals(certs[0].getIssuerDN().getName()) ? certs[certs.length - 1] : certs[0];
                auditCASubjectDN = leafCert.getSubjectDN().getName();
            }
            catch (Exception e) {
                auditor.log((LogEvent)OCSPAddCARequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditCASubjectDN));
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ENCODING_CA_CHAIN_ERROR", (String[])new String[0]));
            }
        }
        if (certs != null && certs.length > 0) {
            CRLIssuingPointRecord rec = defStore.createCRLIssuingPointRecord(leafCert.getSubjectDN().getName(), BIG_ZERO, MINUS_ONE, null, null);
            try {
                rec.set("cACertificate", (Object)leafCert.getEncoded());
            }
            catch (Exception e) {
                auditor.log((LogEvent)OCSPAddCARequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditCASubjectDN));
            }
            defStore.addCRLIssuingPoint(leafCert.getSubjectDN().getName(), rec);
            logger.info("Added CA certificate " + leafCert.getSubjectDN().getName());
            auditor.log((LogEvent)OCSPAddCARequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditCASubjectDN));
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            String xmlOutput = req.getParameter("xml");
            if (xmlOutput != null && xmlOutput.equals("true")) {
                this.outputXML(resp, argSet);
            } else {
                resp.setContentType("text/html");
                form.renderOutput((OutputStream)out, argSet);
                cmsReq.setStatus(CMSRequest.SUCCESS);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }
}

