/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.profile;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProfileInput
implements JSONSerializer {
    private String id;
    private String classId;
    private String name;
    private String text;
    private List<ProfileAttribute> attrs = new ArrayList<ProfileAttribute>();
    private List<ProfileAttribute> configAttrs = new ArrayList<ProfileAttribute>();

    public ProfileInput() {
    }

    public ProfileInput(String id, String name, String classId) {
        this.id = id;
        this.name = name;
        this.classId = classId;
    }

    @JsonProperty(value="ClassID")
    public String getClassId() {
        return this.classId;
    }

    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="Text")
    public String getText() {
        return this.text;
    }

    public void setClassId(String classId) {
        this.classId = classId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="Attribute")
    public Collection<ProfileAttribute> getAttributes() {
        return this.attrs;
    }

    public void setAttributes(Collection<ProfileAttribute> attrs) {
        this.attrs.clear();
        this.attrs.addAll(attrs);
    }

    public ProfileAttribute getAttribute(String name) {
        for (ProfileAttribute attr : this.attrs) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public void addAttribute(ProfileAttribute attr) {
        this.attrs.add(attr);
    }

    public void removeAttribute(String name) {
        this.attrs.remove(name);
    }

    public void clearAttributes() {
        this.attrs.clear();
    }

    @JsonProperty(value="ConfigAttribute")
    public List<ProfileAttribute> getConfigAttrs() {
        return this.configAttrs;
    }

    public void setConfigAttrs(List<ProfileAttribute> configAttrs) {
        this.configAttrs = configAttrs;
    }

    public void addConfigAttribute(ProfileAttribute configAttr) {
        this.configAttrs.add(configAttr);
    }

    public void removeConfigAttribute(ProfileAttribute configAttr) {
        this.configAttrs.remove(configAttr);
    }

    public void clearConfigAttributes() {
        this.configAttrs.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attrs == null ? 0 : this.attrs.hashCode());
        result = 31 * result + (this.classId == null ? 0 : this.classId.hashCode());
        result = 31 * result + (this.configAttrs == null ? 0 : this.configAttrs.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileInput other = (ProfileInput)obj;
        if (this.attrs == null ? other.attrs != null : !this.attrs.equals(other.attrs)) {
            return false;
        }
        if (this.classId == null ? other.classId != null : !this.classId.equals(other.classId)) {
            return false;
        }
        if (this.configAttrs == null ? other.configAttrs != null : !this.configAttrs.equals(other.configAttrs)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public Element toDOM(Document document) {
        Element descriptorElement;
        Descriptor descriptor;
        Element valueElement;
        String value;
        String name;
        Element attributeElement;
        Element profileInputElement = document.createElement("Input");
        if (this.id != null) {
            profileInputElement.setAttribute("id", this.id);
        }
        if (this.classId != null) {
            Element classIDElement = document.createElement("ClassID");
            classIDElement.appendChild(document.createTextNode(this.classId));
            profileInputElement.appendChild(classIDElement);
        }
        if (this.name != null) {
            Element nameElement = document.createElement("Name");
            nameElement.appendChild(document.createTextNode(this.name));
            profileInputElement.appendChild(nameElement);
        }
        for (ProfileAttribute attribute : this.attrs) {
            attributeElement = document.createElement("Attribute");
            name = attribute.getName();
            if (name != null) {
                attributeElement.setAttribute("name", name);
            }
            if ((value = attribute.getValue()) != null) {
                valueElement = document.createElement("Value");
                valueElement.appendChild(document.createTextNode(value));
                attributeElement.appendChild(valueElement);
            }
            if ((descriptor = attribute.getDescriptor()) != null) {
                descriptorElement = descriptor.toDOM(document);
                attributeElement.appendChild(descriptorElement);
            }
            profileInputElement.appendChild(attributeElement);
        }
        for (ProfileAttribute configAttribute : this.configAttrs) {
            attributeElement = document.createElement("ConfigAttribute");
            name = configAttribute.getName();
            if (name != null) {
                attributeElement.setAttribute("name", name);
            }
            if ((value = configAttribute.getValue()) != null) {
                valueElement = document.createElement("Value");
                valueElement.appendChild(document.createTextNode(value));
                attributeElement.appendChild(valueElement);
            }
            if ((descriptor = configAttribute.getDescriptor()) != null) {
                descriptorElement = descriptor.toDOM(document);
                attributeElement.appendChild(descriptorElement);
            }
            profileInputElement.appendChild(attributeElement);
        }
        return profileInputElement;
    }

    public static ProfileInput fromDOM(Element profileInputElement) {
        NodeList nameList;
        ProfileInput profileInput = new ProfileInput();
        String id = profileInputElement.getAttribute("id");
        profileInput.setId(id);
        NodeList classIDList = profileInputElement.getElementsByTagName("ClassID");
        if (classIDList.getLength() > 0) {
            String value = classIDList.item(0).getTextContent();
            profileInput.setClassId(value);
        }
        if ((nameList = profileInputElement.getElementsByTagName("Name")).getLength() > 0) {
            String value = nameList.item(0).getTextContent();
            profileInput.setName(value);
        }
        NodeList attributeList = profileInputElement.getElementsByTagName("Attribute");
        for (int i = 0; i < attributeList.getLength(); ++i) {
            NodeList descriptorList;
            Element attributeElement = (Element)attributeList.item(i);
            ProfileAttribute profileAttribute = new ProfileAttribute();
            String attributeId = attributeElement.getAttribute("name");
            profileAttribute.setName(attributeId);
            NodeList valueList = attributeElement.getElementsByTagName("Value");
            if (valueList.getLength() > 0) {
                String value = valueList.item(0).getTextContent();
                profileAttribute.setValue(value);
            }
            if ((descriptorList = attributeElement.getElementsByTagName("Descriptor")).getLength() > 0) {
                Element descriptorElement = (Element)descriptorList.item(0);
                Descriptor descriptor = Descriptor.fromDOM(descriptorElement);
                profileAttribute.setDescriptor(descriptor);
            }
            profileInput.addAttribute(profileAttribute);
        }
        NodeList configAttributeList = profileInputElement.getElementsByTagName("ConfigAttribute");
        for (int i = 0; i < configAttributeList.getLength(); ++i) {
            NodeList descriptorList;
            NodeList valueList;
            Element configAttributeElement = (Element)configAttributeList.item(i);
            ProfileAttribute profileAttribute = new ProfileAttribute();
            String configAttributeId = configAttributeElement.getAttribute("name");
            profileAttribute.setName(configAttributeId);
            NodeList configAttributeNameList = configAttributeElement.getElementsByTagName("Name");
            if (configAttributeNameList.getLength() > 0) {
                String name = configAttributeNameList.item(0).getTextContent();
                profileAttribute.setName(name);
            }
            if ((valueList = configAttributeElement.getElementsByTagName("Value")).getLength() > 0) {
                String value = valueList.item(0).getTextContent();
                profileAttribute.setValue(value);
            }
            if ((descriptorList = configAttributeElement.getElementsByTagName("Descriptor")).getLength() > 0) {
                Element descriptorElement = (Element)descriptorList.item(0);
                Descriptor descriptor = Descriptor.fromDOM(descriptorElement);
                profileAttribute.setDescriptor(descriptor);
            }
            profileInput.addConfigAttribute(profileAttribute);
        }
        return profileInput;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = this.toDOM(document);
        document.appendChild(element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static ProfileInput fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element profileElement = document.getDocumentElement();
        return ProfileInput.fromDOM(profileElement);
    }
}

