/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import com.netscape.cmsutil.ocsp.CertID;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;

public class Request
implements ASN1Value {
    private CertID reqCert = null;
    private SEQUENCE singleRequestExtensions = null;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public CertID getCertID() {
        return this.reqCert;
    }

    public int getExtensionsCount() {
        return this.singleRequestExtensions == null ? 0 : this.singleRequestExtensions.size();
    }

    public Extension getRequestExtensionAt(int index) {
        if (this.singleRequestExtensions == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Extension)this.singleRequestExtensions.elementAt(index);
    }

    public Request(CertID reqCert, SEQUENCE singleRequestExtensions) {
        this.reqCert = reqCert;
        this.sequence.addElement((ASN1Value)reqCert);
        if (singleRequestExtensions != null) {
            this.singleRequestExtensions = singleRequestExtensions;
            this.sequence.addElement((ASN1Value)singleRequestExtensions);
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)CertID.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new SEQUENCE.OF_Template((ASN1Template)new Extension.Template())));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            EXPLICIT tag = (EXPLICIT)seq.elementAt(1);
            if (tag == null) {
                return new Request((CertID)seq.elementAt(0), null);
            }
            return new Request((CertID)seq.elementAt(0), (SEQUENCE)tag.getContent());
        }
    }
}

