/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.ca;

import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.request.RequestId;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAAgentCertRequestClient
extends Client {
    public static final Logger logger = LoggerFactory.getLogger(CAAgentCertRequestClient.class);

    public CAAgentCertRequestClient(PKIClient client) throws Exception {
        super(client, "ca", "agent/certrequests");
    }

    public CertRequestInfos listRequests(String requestState, String requestType, RequestId start, Integer pageSize, Integer maxResults, Integer maxTime) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (requestType != null) {
            params.put("requestType", requestType);
        }
        if (start != null) {
            params.put("start", start.toHexString());
        }
        if (pageSize != null) {
            params.put("pageSize", pageSize);
        }
        if (maxResults != null) {
            params.put("maxResults", maxResults);
        }
        if (maxTime != null) {
            params.put("maxTime", maxTime);
        }
        return this.get(null, params, CertRequestInfos.class);
    }

    public CertReviewResponse reviewRequest(RequestId id) throws Exception {
        return this.get(id.toHexString(), CertReviewResponse.class);
    }

    public void approveRequest(RequestId id, CertReviewResponse data) throws Exception {
        Entity<CertReviewResponse> entity = this.client.entity(data);
        this.post(id.toHexString() + "/approve", null, entity, Void.class);
    }

    public void rejectRequest(RequestId id, CertReviewResponse data) throws Exception {
        Entity<CertReviewResponse> entity = this.client.entity(data);
        this.post(id.toHexString() + "/reject", null, entity, Void.class);
    }

    public void cancelRequest(RequestId id, CertReviewResponse data) throws Exception {
        Entity<CertReviewResponse> entity = this.client.entity(data);
        this.post(id.toHexString() + "/cancel", null, entity, Void.class);
    }

    public void updateRequest(RequestId id, CertReviewResponse data) throws Exception {
        Entity<CertReviewResponse> entity = this.client.entity(data);
        this.post(id.toHexString() + "/update", null, entity, Void.class);
    }

    public void validateRequest(RequestId id, CertReviewResponse data) throws Exception {
        Entity<CertReviewResponse> entity = this.client.entity(data);
        this.post(id.toHexString() + "/validate", null, entity, Void.class);
    }

    public void assignRequest(RequestId id, CertReviewResponse data) throws Exception {
        Entity<CertReviewResponse> entity = this.client.entity(data);
        this.post(id.toHexString() + "/assign", null, entity, Void.class);
    }

    public void unassignRequest(RequestId id, CertReviewResponse data) throws Exception {
        Entity<CertReviewResponse> entity = this.client.entity(data);
        this.post(id.toHexString() + "/unassign", null, entity, Void.class);
    }
}

