/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.ca;

import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.profile.ProfileDataInfos;
import com.netscape.certsrv.request.RequestId;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRequestClient
extends Client {
    public static final Logger logger = LoggerFactory.getLogger(CACertRequestClient.class);

    public CACertRequestClient(PKIClient client) throws Exception {
        super(client, "ca", "certrequests");
    }

    public CertRequestInfo getRequest(RequestId id) throws Exception {
        return this.get(id.toHexString(), CertRequestInfo.class);
    }

    public CertRequestInfos enrollRequest(CertEnrollmentRequest data, AuthorityID aid, X500Name adn) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (aid != null) {
            params.put("issuer-id", aid.toString());
        }
        if (adn != null) {
            params.put("issuer-dn", adn.toLdapDNString());
        }
        String enrollmentRequest = (String)this.client.marshall(data);
        Entity<String> entity = this.client.entity(enrollmentRequest);
        return this.post(null, params, entity, CertRequestInfos.class);
    }

    public ProfileDataInfos listEnrollmentTemplates(Integer start, Integer size) throws Exception {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get("profiles", ProfileDataInfos.class);
    }

    public CertEnrollmentRequest getEnrollmentTemplate(String id) throws Exception {
        return this.get("profiles/" + id, CertEnrollmentRequest.class);
    }
}

