/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.client;

import com.netscape.certsrv.client.PKIClient;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.Principal;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKICertificateApprovalCallback
implements SSLCertificateApprovalCallback {
    public static Logger logger = LoggerFactory.getLogger(PKICertificateApprovalCallback.class);
    public PKIClient client;

    public PKICertificateApprovalCallback(PKIClient client) {
        this.client = client;
    }

    public String displayReason(int reason) {
        for (Field f : SSLCertificateApprovalCallback.ValidityStatus.class.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || !Modifier.isFinal(mod)) continue;
            try {
                int value = f.getInt(null);
                if (value != reason) continue;
                return f.getName();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getMessage(X509Certificate serverCert, int reason) {
        if (reason == -12276) {
            return "BAD_CERT_DOMAIN encountered on '" + serverCert.getSubjectDN() + "' indicates a common-name mismatch";
        }
        if (reason == -8172) {
            return "UNTRUSTED ISSUER encountered on '" + serverCert.getSubjectDN() + "' indicates a non-trusted CA cert '" + serverCert.getIssuerDN() + "'";
        }
        if (reason == -8156) {
            return "CA_CERT_INVALID encountered on '" + serverCert.getSubjectDN() + "' results in a denied SSL server cert!";
        }
        String reasonName = this.displayReason(reason);
        if (reasonName != null) {
            return reasonName + " encountered on '" + serverCert.getSubjectDN() + "' results in a denied SSL server cert!";
        }
        return "Unknown/undefined reason " + reason + " encountered on '" + serverCert.getSubjectDN() + "' results in a denied SSL server cert!";
    }

    public boolean handleUntrustedIssuer(X509Certificate serverCert) {
        try {
            System.err.print("Trust this certificate (y/N)? ");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine().trim();
            if (!line.equalsIgnoreCase("Y")) {
                return false;
            }
            Principal subjectDN = serverCert.getSubjectDN();
            String nickname = subjectDN.getName();
            logger.info("Importing certificate as " + nickname);
            CryptoManager manager = CryptoManager.getInstance();
            manager.importCertToPerm(serverCert, nickname);
            logger.info("Trusting certificate");
            InternalCertificate internalCert = (InternalCertificate)serverCert;
            internalCert.setSSLTrust(2);
            return true;
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            return false;
        }
    }

    public boolean approve(X509Certificate serverCert, SSLCertificateApprovalCallback.ValidityStatus status) {
        boolean approval = true;
        logger.info("Server certificate: " + serverCert.getSubjectDN());
        Enumeration errors = status.getReasons();
        while (errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            int reason = item.getReason();
            if (this.client.isRejected(reason)) {
                if (!this.client.statuses.contains(reason)) {
                    System.err.println("ERROR: " + this.getMessage(serverCert, reason));
                }
                approval = false;
            } else if (!this.client.isIgnored(reason)) {
                if (reason == -8172) {
                    if (!this.client.statuses.contains(reason)) {
                        System.err.println("WARNING: " + this.getMessage(serverCert, reason));
                        approval = this.handleUntrustedIssuer(serverCert);
                    }
                } else if (reason == -12276) {
                    if (!this.client.statuses.contains(reason)) {
                        System.err.println("WARNING: " + this.getMessage(serverCert, reason));
                    }
                } else if (reason == -8156) {
                    if (!this.client.statuses.contains(reason)) {
                        System.err.println("ERROR: " + this.getMessage(serverCert, reason));
                    }
                    approval = false;
                } else {
                    if (!this.client.statuses.contains(reason)) {
                        System.err.println("ERROR: " + this.getMessage(serverCert, reason));
                    }
                    approval = false;
                }
            }
            this.client.statuses.add(reason);
        }
        return approval;
    }
}

