/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.key;

import com.netscape.certsrv.base.RESTMessage;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.key.AsymKeyGenerationRequest;
import com.netscape.certsrv.key.Key;
import com.netscape.certsrv.key.KeyArchivalRequest;
import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.key.KeyInfo;
import com.netscape.certsrv.key.KeyInfoCollection;
import com.netscape.certsrv.key.KeyRecoveryRequest;
import com.netscape.certsrv.key.KeyRequestClient;
import com.netscape.certsrv.key.KeyRequestInfo;
import com.netscape.certsrv.key.KeyRequestInfoCollection;
import com.netscape.certsrv.key.KeyRequestResponse;
import com.netscape.certsrv.key.SymKeyGenerationRequest;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.util.CryptoProvider;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import org.dogtagpki.common.Info;
import org.dogtagpki.common.Version;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyClient
extends Client {
    public static Logger logger = LoggerFactory.getLogger(KeyClient.class);
    public KeyRequestClient keyRequestClient;
    private CryptoProvider crypto;
    private X509Certificate transportCert;
    private EncryptionAlgorithm encryptAlgorithm;
    private KeyWrapAlgorithm wrapAlgorithm;
    private int wrapIVLength;
    private boolean useOAEP = false;

    public KeyClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "agent/keys");
        this.init();
        this.crypto = client.getCrypto();
        Version serverVersion = this.getServerVersion();
        if (serverVersion.isNewerThanOrEquals(new Version("10.4"))) {
            this.encryptAlgorithm = EncryptionAlgorithm.AES_128_CBC_PAD;
            this.wrapAlgorithm = KeyWrapAlgorithm.AES_KEY_WRAP_PAD;
            this.wrapIVLength = 0;
        } else {
            this.encryptAlgorithm = EncryptionAlgorithm.DES3_CBC;
            this.wrapAlgorithm = KeyWrapAlgorithm.DES3_CBC_PAD;
            this.wrapIVLength = 8;
        }
    }

    private Version getServerVersion() {
        Version ret = null;
        try {
            Info info = this.client.getInfo();
            String version = info.getVersion();
            ret = new Version(version);
        }
        catch (Exception e) {
            ret = new Version("0.0.0");
        }
        return ret;
    }

    public void init() throws Exception {
        this.keyRequestClient = new KeyRequestClient(this.client);
    }

    public CryptoProvider getCrypto() {
        return this.crypto;
    }

    public void setCrypto(CryptoProvider crypto) {
        this.crypto = crypto;
    }

    public void setTransportCert(X509Certificate transportCert) throws Exception {
        this.transportCert = transportCert;
    }

    public void setUseOAEP(boolean useOAEP) {
        this.useOAEP = useOAEP;
    }

    public boolean getUseOAEP() {
        return this.useOAEP;
    }

    public KeyInfoCollection listKeys(String clientKeyID, String status, Integer maxResults, Integer maxTime, Integer start, Integer size, String realm, String ownerName) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (clientKeyID != null) {
            params.put("clientKeyID", clientKeyID);
        }
        if (status != null) {
            params.put("status", status);
        }
        if (maxResults != null) {
            params.put("maxResults", maxResults);
        }
        if (maxTime != null) {
            params.put("maxTime", maxTime);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        if (realm != null) {
            params.put("realm", realm);
        }
        if (ownerName != null) {
            params.put("owner", ownerName);
        }
        return this.get(null, params, KeyInfoCollection.class);
    }

    @Deprecated(since="11.5.0", forRemoval=true)
    public KeyInfoCollection listKeys(String clientKeyID, String status, Integer maxResults, Integer maxTime, Integer start, Integer size, String ownerName) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (clientKeyID != null) {
            params.put("clientKeyID", clientKeyID);
        }
        if (status != null) {
            params.put("status", status);
        }
        if (maxResults != null) {
            params.put("maxResults", maxResults);
        }
        if (maxTime != null) {
            params.put("maxTime", maxTime);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        if (ownerName != null) {
            params.put("realm", ownerName);
        }
        return this.get(null, params, KeyInfoCollection.class);
    }

    public KeyRequestInfoCollection listRequests(String requestState, String requestType, String realm) throws Exception {
        return this.listRequests(requestState, requestType, null, new RequestId(0), 100, 100, 10, realm);
    }

    public KeyRequestInfoCollection listRequests(String requestState, String requestType) throws Exception {
        return this.listRequests(requestState, requestType, null, new RequestId(0), 100, 100, 10, null);
    }

    public KeyRequestInfoCollection listRequests(String requestState, String requestType, String clientKeyID, RequestId start, Integer pageSize, Integer maxResults, Integer maxTime, String realm) throws Exception {
        return this.keyRequestClient.listRequests(requestState, requestType, clientKeyID, start, pageSize, maxResults, maxTime, realm);
    }

    public KeyRequestInfo getRequestInfo(RequestId id) throws Exception {
        return this.keyRequestClient.getRequestInfo(id);
    }

    public KeyInfo getKeyInfo(KeyId id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("Key Id must be specified.");
        }
        return this.get(id.toHexString(), KeyInfo.class);
    }

    public KeyInfo getActiveKeyInfo(String clientKeyID) throws Exception {
        if (clientKeyID == null) {
            throw new IllegalArgumentException("Client Key Id must be specified.");
        }
        return this.get("active/" + clientKeyID, KeyInfo.class);
    }

    public void modifyKeyStatus(KeyId id, String status) throws Exception {
        if (id == null || status == null) {
            throw new IllegalArgumentException("Key Id and status must be specified.");
        }
        if (!status.equalsIgnoreCase("active") && !status.equalsIgnoreCase("inactive")) {
            throw new IllegalArgumentException("Invalid status value.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (status != null) {
            params.put("status", status);
        }
        this.post(id.toHexString(), params, null, Void.class);
    }

    public void approveRequest(RequestId id) throws Exception {
        this.keyRequestClient.approveRequest(id);
    }

    public void rejectRequest(RequestId id) throws Exception {
        this.keyRequestClient.rejectRequest(id);
    }

    public void cancelRequest(RequestId id) throws Exception {
        this.keyRequestClient.cancelRequest(id);
    }

    private KeyRequestResponse submitRequest(RESTMessage request) throws Exception {
        return this.keyRequestClient.submitRequest(request);
    }

    public KeyRequestResponse recoverKey(KeyId keyId, byte[] sessionWrappedPassphrase, byte[] transWrappedSessionKey, byte[] nonceData, String b64Certificate) throws Exception {
        if (keyId == null) {
            throw new IllegalArgumentException("KeyId nust be specified.");
        }
        KeyRecoveryRequest data = new KeyRecoveryRequest();
        data.setKeyId(keyId);
        if (sessionWrappedPassphrase != null) {
            data.setSessionWrappedPassphrase(Utils.base64encode((byte[])sessionWrappedPassphrase, (boolean)false));
        }
        if (transWrappedSessionKey != null) {
            data.setTransWrappedSessionKey(Utils.base64encode((byte[])transWrappedSessionKey, (boolean)false));
        }
        if (nonceData != null) {
            data.setNonceData(Utils.base64encode((byte[])nonceData, (boolean)false));
        }
        if (b64Certificate != null) {
            data.setCertificate(b64Certificate);
        }
        return this.submitRequest(data);
    }

    public KeyData retrieveKeyData(KeyRecoveryRequest data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("A KeyRecoveryRequest object must be specified");
        }
        logger.info("Submitting key retrieval request to KRA");
        Entity<KeyRecoveryRequest> entity = this.client.entity(data);
        return this.post("retrieve", null, entity, KeyData.class);
    }

    public SymmetricKey generateSessionKey() throws Exception {
        return this.crypto.generateSessionKey(this.encryptAlgorithm);
    }

    public KeyData retrieveKey(KeyId keyId, SymmetricKey sessionKey) throws Exception {
        logger.info("Retrieving key " + keyId + " with session key");
        if (keyId == null) {
            throw new IllegalArgumentException("KeyId must be specified.");
        }
        logger.info("Wrapping session key with transport certificate");
        KeyWrapAlgorithm alg = KeyWrapAlgorithm.RSA;
        if (this.useOAEP) {
            alg = KeyWrapAlgorithm.RSA_OAEP;
        }
        byte[] transWrappedSessionKey = this.crypto.wrapSymmetricKey(sessionKey, this.transportCert.getPublicKey(), alg);
        return this.retrieveKey(keyId, transWrappedSessionKey);
    }

    public void processKeyData(Key data, SymmetricKey sessionKey) throws Exception {
        if (data.getEncryptedData() == null) {
            return;
        }
        if (data.getWrapAlgorithm() == null) {
            data.setData(this.crypto.unwrapWithSessionKey(data.getEncryptedData(), sessionKey, this.encryptAlgorithm, data.getNonceData()));
            return;
        }
        byte[] bytes = null;
        if (data.getType().equalsIgnoreCase("symmetricKey")) {
            bytes = this.crypto.unwrapSymmetricKeyWithSessionKey(data.getEncryptedData(), sessionKey, KeyWrapAlgorithm.fromString((String)data.getWrapAlgorithm()), data.getNonceData(), data.getAlgorithm(), data.getSize());
        } else {
            byte[] pubKeyBytes = Utils.base64decode((String)data.getPublicKey());
            PublicKey pubKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(pubKeyBytes));
            bytes = this.crypto.unwrapAsymmetricKeyWithSessionKey(data.getEncryptedData(), sessionKey, KeyWrapAlgorithm.fromString((String)data.getWrapAlgorithm()), data.getNonceData(), pubKey);
        }
        data.setData(bytes);
    }

    public KeyData retrieveKeyByRequest(RequestId requestId, SymmetricKey sessionKey) throws Exception {
        if (requestId == null) {
            throw new IllegalArgumentException("RequestId must be specified.");
        }
        KeyWrapAlgorithm alg = KeyWrapAlgorithm.RSA;
        if (this.useOAEP) {
            alg = KeyWrapAlgorithm.RSA_OAEP;
        }
        byte[] transWrappedSessionKey = this.crypto.wrapSymmetricKey(sessionKey, this.transportCert.getPublicKey(), alg);
        KeyRecoveryRequest recoveryRequest = new KeyRecoveryRequest();
        recoveryRequest.setRequestId(requestId);
        recoveryRequest.setTransWrappedSessionKey(Utils.base64encode((byte[])transWrappedSessionKey, (boolean)false));
        recoveryRequest.setPayloadEncryptionOID(this.getEncryptAlgorithmOID());
        recoveryRequest.setPayloadWrappingName(this.wrapAlgorithm.toString());
        return this.retrieveKeyData(recoveryRequest);
    }

    public KeyData retrieveKey(KeyId keyId, byte[] transWrappedSessionKey) throws Exception {
        logger.info("Retrieving key " + keyId + " with session key wrapped by transport certificate");
        if (keyId == null) {
            throw new IllegalArgumentException("KeyId must be specified.");
        }
        if (transWrappedSessionKey == null) {
            throw new IllegalArgumentException("A transport cert wrapped session key cannot be null.");
        }
        KeyRecoveryRequest recoveryRequest = new KeyRecoveryRequest();
        recoveryRequest.setKeyId(keyId);
        recoveryRequest.setTransWrappedSessionKey(Utils.base64encode((byte[])transWrappedSessionKey, (boolean)false));
        recoveryRequest.setPayloadEncryptionOID(this.getEncryptAlgorithmOID());
        recoveryRequest.setPayloadWrappingName(this.getWrapAlgorithmName());
        return this.retrieveKeyData(recoveryRequest);
    }

    public KeyData retrieveKeyByPassphrase(KeyId keyId, String passphrase) throws Exception {
        if (keyId == null) {
            throw new IllegalArgumentException("KeyId must be specified.");
        }
        if (passphrase == null) {
            throw new IllegalArgumentException("Passphrase must be specified.");
        }
        KeyWrapAlgorithm alg = KeyWrapAlgorithm.RSA;
        if (this.useOAEP) {
            alg = KeyWrapAlgorithm.RSA_OAEP;
        }
        SymmetricKey sessionKey = this.generateSessionKey();
        byte[] transWrappedSessionKey = this.crypto.wrapSymmetricKey(sessionKey, this.transportCert.getPublicKey(), alg);
        byte[] nonceData = CryptoUtil.getNonceData(this.encryptAlgorithm.getIVLength());
        byte[] secret = passphrase.getBytes("UTF-8");
        byte[] sessionWrappedPassphrase = this.crypto.encryptSecret(secret, nonceData, sessionKey, this.encryptAlgorithm);
        return this.retrieveKeyUsingWrappedPassphrase(keyId, transWrappedSessionKey, sessionWrappedPassphrase, nonceData);
    }

    public Key retrieveKeyByRequestWithPassphrase(RequestId requestId, String passphrase) throws Exception {
        if (requestId == null) {
            throw new IllegalArgumentException("RequestId must be specified.");
        }
        if (passphrase == null) {
            throw new IllegalArgumentException("Passphrase must be specified.");
        }
        KeyWrapAlgorithm alg = KeyWrapAlgorithm.RSA;
        if (this.useOAEP) {
            alg = KeyWrapAlgorithm.RSA_OAEP;
        }
        SymmetricKey sessionKey = this.generateSessionKey();
        byte[] transWrappedSessionKey = this.crypto.wrapSymmetricKey(sessionKey, this.transportCert.getPublicKey(), alg);
        byte[] nonceData = CryptoUtil.getNonceData(this.encryptAlgorithm.getIVLength());
        byte[] secret = passphrase.getBytes("UTF-8");
        byte[] sessionWrappedPassphrase = this.crypto.encryptSecret(secret, nonceData, sessionKey, this.encryptAlgorithm);
        KeyRecoveryRequest data = new KeyRecoveryRequest();
        data.setRequestId(requestId);
        data.setTransWrappedSessionKey(Utils.base64encode((byte[])transWrappedSessionKey, (boolean)false));
        data.setSessionWrappedPassphrase(Utils.base64encode((byte[])sessionWrappedPassphrase, (boolean)false));
        data.setNonceData(Utils.base64encode((byte[])nonceData, (boolean)false));
        data.setPayloadEncryptionOID(this.getEncryptAlgorithmOID());
        data.setPayloadWrappingName(this.wrapAlgorithm.toString());
        return new Key(this.retrieveKeyData(data));
    }

    public KeyData retrieveKeyUsingWrappedPassphrase(KeyId keyId, byte[] transWrappedSessionKey, byte[] sessionWrappedPassphrase, byte[] nonceData) throws Exception {
        if (keyId == null) {
            throw new IllegalArgumentException("KeyId has to be specified.");
        }
        if (sessionWrappedPassphrase == null) {
            throw new IllegalArgumentException("Session key wrapped passphrase must be specified.");
        }
        if (transWrappedSessionKey == null || nonceData == null) {
            throw new IllegalArgumentException("No way to extract passphrase. Both transWrappedSessionKey and nonceData must be specified.");
        }
        RequestId requestId = this.recoverKey(keyId, null, null, null, null).getRequestId();
        this.approveRequest(requestId);
        KeyRecoveryRequest data = new KeyRecoveryRequest();
        data.setKeyId(keyId);
        data.setRequestId(requestId);
        data.setPayloadEncryptionOID(this.getEncryptAlgorithmOID());
        data.setPayloadWrappingName(this.wrapAlgorithm.toString());
        if (transWrappedSessionKey != null) {
            data.setTransWrappedSessionKey(Utils.base64encode((byte[])transWrappedSessionKey, (boolean)false));
        }
        if (sessionWrappedPassphrase != null) {
            data.setSessionWrappedPassphrase(Utils.base64encode((byte[])sessionWrappedPassphrase, (boolean)false));
        }
        if (nonceData != null) {
            data.setNonceData(Utils.base64encode((byte[])nonceData, (boolean)false));
        }
        return this.retrieveKeyData(data);
    }

    public KeyData retrieveKeyByPKCS12(KeyId keyId, String certificate, String passphrase) throws Exception {
        if (keyId == null || certificate == null || passphrase == null) {
            throw new IllegalArgumentException("KeyId, certificate and passphrase must be specified.");
        }
        KeyRequestResponse keyData = this.recoverKey(keyId, null, null, null, certificate);
        this.approveRequest(keyData.getRequestId());
        KeyRecoveryRequest recoveryRequest = new KeyRecoveryRequest();
        recoveryRequest.setKeyId(keyId);
        recoveryRequest.setRequestId(keyData.getRequestId());
        recoveryRequest.setPassphrase(passphrase);
        return this.retrieveKeyData(recoveryRequest);
    }

    public KeyRequestResponse archiveSecret(String clientKeyId, byte[] secret, String realm) throws Exception {
        String algorithmOID = this.getEncryptAlgorithmOID();
        byte[] nonceData = CryptoUtil.getNonceData(this.encryptAlgorithm.getIVLength());
        SymmetricKey sessionKey = this.generateSessionKey();
        KeyWrapAlgorithm alg = KeyWrapAlgorithm.RSA;
        if (this.useOAEP) {
            alg = KeyWrapAlgorithm.RSA_OAEP;
        }
        byte[] transWrappedSessionKey = this.crypto.wrapSymmetricKey(sessionKey, this.transportCert.getPublicKey(), alg);
        byte[] encryptedData = this.crypto.encryptSecret(secret, nonceData, sessionKey, this.encryptAlgorithm);
        return this.archiveEncryptedData(clientKeyId, "passPhrase", null, null, algorithmOID, nonceData, encryptedData, transWrappedSessionKey, realm);
    }

    public KeyRequestResponse archiveSecret(String clientKeyId, byte[] secret) throws Exception {
        return this.archiveSecret(clientKeyId, secret, null);
    }

    private String getEncryptAlgorithmOID() throws NoSuchAlgorithmException {
        String algorithmOID = this.encryptAlgorithm.getAlg().toString().equalsIgnoreCase("AES") ? EncryptionAlgorithm.AES_128_CBC.toOID().toString() : this.encryptAlgorithm.toOID().toString();
        return algorithmOID;
    }

    public String getWrapAlgorithmName() {
        return this.wrapAlgorithm.toString();
    }

    public KeyRequestResponse archiveSymmetricKey(String clientKeyId, SymmetricKey secret, String keyAlgorithm, Integer keySize, String realm) throws Exception {
        String algorithmOID = this.getEncryptAlgorithmOID();
        byte[] nonceData = null;
        if (this.wrapIVLength > 0) {
            nonceData = CryptoUtil.getNonceData(this.wrapIVLength);
        }
        KeyWrapAlgorithm alg = KeyWrapAlgorithm.RSA;
        if (this.useOAEP) {
            alg = KeyWrapAlgorithm.RSA_OAEP;
        }
        SymmetricKey sessionKey = this.generateSessionKey();
        byte[] encryptedData = this.crypto.wrapWithSessionKey(secret, sessionKey, nonceData, this.wrapAlgorithm);
        byte[] transWrappedSessionKey = this.crypto.wrapSymmetricKey(sessionKey, this.transportCert.getPublicKey(), alg);
        return this.archiveEncryptedData(clientKeyId, "symmetricKey", keyAlgorithm, keySize, algorithmOID, nonceData, encryptedData, transWrappedSessionKey, realm);
    }

    @Deprecated
    public KeyRequestResponse archiveSymmetricKey(String clientKeyId, SymmetricKey secret, String keyAlgorithm, Integer keySize) throws Exception {
        return this.archiveSymmetricKey(clientKeyId, secret, keyAlgorithm, keySize, null);
    }

    public KeyRequestResponse archiveEncryptedData(String clientKeyId, String dataType, String keyAlgorithm, Integer keySize, String algorithmOID, byte[] nonceData, byte[] encryptedData, byte[] transWrappedSessionKey, String realm) throws Exception {
        logger.info("Archiving encrypted data");
        if (clientKeyId == null || dataType == null) {
            throw new IllegalArgumentException("Client key id and data type must be specified.");
        }
        if (dataType == "symmetricKey" && (keyAlgorithm == null || keySize < 0)) {
            throw new IllegalArgumentException("Key algorithm and key size must be specified for a symmetric key type request.");
        }
        if (encryptedData == null || transWrappedSessionKey == null || algorithmOID == null || nonceData == null) {
            throw new IllegalArgumentException("All data and wrapping parameters must be specified.");
        }
        KeyArchivalRequest data = new KeyArchivalRequest();
        data.setDataType(dataType);
        data.setKeyAlgorithm(keyAlgorithm);
        data.setKeySize(keySize);
        data.setClientKeyId(clientKeyId);
        data.setAlgorithmOID(algorithmOID);
        data.setSymmetricAlgorithmParams(Utils.base64encode((byte[])nonceData, (boolean)false));
        data.setWrappedPrivateData(Utils.base64encode((byte[])encryptedData, (boolean)false));
        data.setTransWrappedSessionKey(Utils.base64encode((byte[])transWrappedSessionKey, (boolean)false));
        data.setRealm(realm);
        return this.submitRequest(data);
    }

    @Deprecated
    public KeyRequestResponse archiveEncryptedData(String clientKeyId, String dataType, String keyAlgorithm, Integer keySize, String algorithmOID, byte[] nonceData, byte[] encryptedData, byte[] transWrappedSessionKey) throws Exception {
        return this.archiveEncryptedData(clientKeyId, dataType, keyAlgorithm, keySize, algorithmOID, nonceData, encryptedData, transWrappedSessionKey, null);
    }

    public KeyRequestResponse archivePKIOptions(String clientKeyId, String dataType, String keyAlgorithm, int keySize, byte[] pkiArchiveOptions, String realm) throws Exception {
        if (clientKeyId == null || dataType == null) {
            throw new IllegalArgumentException("Client key id and data type must be specified.");
        }
        if (dataType == "symmetricKey" && (keyAlgorithm == null || keySize < 0)) {
            throw new IllegalArgumentException("Key algorithm and key size must be specified for a symmetric key type request.");
        }
        if (pkiArchiveOptions == null) {
            throw new IllegalArgumentException("No data provided to be archived. PKIArchiveOptions data must be specified.");
        }
        KeyArchivalRequest data = new KeyArchivalRequest();
        data.setClientKeyId(clientKeyId);
        data.setDataType(dataType);
        data.setKeyAlgorithm(keyAlgorithm);
        data.setKeySize(keySize);
        String options = Utils.base64encode((byte[])pkiArchiveOptions, (boolean)false);
        data.setPKIArchiveOptions(options);
        data.setRealm(realm);
        return this.submitRequest(data);
    }

    @Deprecated
    public KeyRequestResponse archivePKIOptions(String clientKeyId, String dataType, String keyAlgorithm, int keySize, byte[] pkiArchiveOptions) throws Exception {
        return this.archivePKIOptions(clientKeyId, dataType, keyAlgorithm, keySize, pkiArchiveOptions, null);
    }

    public KeyRequestResponse generateSymmetricKey(String clientKeyId, String keyAlgorithm, int keySize, List<String> usages, String transWrappedSessionKey, String realm) throws Exception {
        if (clientKeyId == null) {
            throw new IllegalArgumentException("Client Key Identifier must be specified.");
        }
        List<String> validUsages = SymKeyGenerationRequest.getValidUsagesList();
        if (usages != null) {
            for (String usage : usages) {
                if (validUsages.contains(usage)) continue;
                throw new IllegalArgumentException("Invalid usage \"" + usage + "\" specified.");
            }
        }
        SymKeyGenerationRequest data = new SymKeyGenerationRequest();
        data.setClientKeyId(clientKeyId);
        data.setKeyAlgorithm(keyAlgorithm);
        data.setKeySize(keySize);
        data.setUsages(usages);
        data.setTransWrappedSessionKey(transWrappedSessionKey);
        data.setRealm(realm);
        return this.submitRequest(data);
    }

    @Deprecated
    public KeyRequestResponse generateSymmetricKey(String clientKeyId, String keyAlgorithm, int keySize, List<String> usages, String transWrappedSessionKey) throws Exception {
        return this.generateSymmetricKey(clientKeyId, keyAlgorithm, keySize, usages, transWrappedSessionKey, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeyRequestResponse generateAsymmetricKey(String clientKeyId, String keyAlgorithm, int keySize, List<String> usages, byte[] transWrappedSessionKey, String realm) throws Exception {
        if (clientKeyId == null) {
            throw new IllegalArgumentException("Client Key Identifier must be specified.");
        }
        List<String> validUsages = AsymKeyGenerationRequest.getValidUsagesList();
        if (usages != null) {
            for (String usage : usages) {
                if (validUsages.contains(usage)) continue;
                throw new IllegalArgumentException("Invalid usage \"" + usage + "\" specified.");
            }
        }
        if (!keyAlgorithm.equals("RSA") && !keyAlgorithm.equals("DSA")) {
            throw new IllegalArgumentException("Unsupported algorithm specified.");
        }
        if (keyAlgorithm.equals("RSA")) {
            if (keySize < 256) throw new IllegalArgumentException("Invalid key size specified.");
            if ((keySize - 256) % 16 != 0) {
                throw new IllegalArgumentException("Invalid key size specified.");
            }
        } else if (keyAlgorithm.equals("DSA") && keySize != 512 && keySize != 768 && keySize != 1024) {
            throw new IllegalArgumentException("Invalid key size specified.");
        }
        AsymKeyGenerationRequest data = new AsymKeyGenerationRequest();
        data.setClientKeyId(clientKeyId);
        data.setKeyAlgorithm(keyAlgorithm);
        data.setKeySize(keySize);
        data.setUsages(usages);
        if (transWrappedSessionKey != null) {
            data.setTransWrappedSessionKey(Utils.base64encode((byte[])transWrappedSessionKey, (boolean)false));
        }
        data.setRealm(realm);
        return this.submitRequest(data);
    }

    @Deprecated
    public KeyRequestResponse generateAsymmetricKey(String clientKeyId, String keyAlgorithm, int keySize, List<String> usages, byte[] transWrappedSessionKey) throws Exception {
        return this.generateAsymmetricKey(clientKeyId, keyAlgorithm, keySize, usages, transWrappedSessionKey, null);
    }
}

