/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.key;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.request.CMSRequestInfo;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeyRequestInfo
extends CMSRequestInfo {
    protected String keyURL;

    public String getKeyURL() {
        return this.keyURL;
    }

    public KeyId getKeyId() {
        if (this.keyURL == null) {
            return null;
        }
        String id = this.keyURL.substring(this.keyURL.lastIndexOf("/") + 1);
        return new KeyId(id);
    }

    public void setKeyURL(String keyURL) {
        this.keyURL = keyURL;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.keyURL == null ? 0 : this.keyURL.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyRequestInfo other = (KeyRequestInfo)obj;
        return !(this.keyURL == null ? other.keyURL != null : !this.keyURL.equals(other.keyURL));
    }

    @Override
    public Element toDOM(Document document) {
        Element infoElement = document.createElement("CertDataInfo");
        this.toDOM(document, infoElement);
        if (this.keyURL != null) {
            Element subjectDNElement = document.createElement("keyURL");
            subjectDNElement.appendChild(document.createTextNode(this.keyURL));
            infoElement.appendChild(subjectDNElement);
        }
        return infoElement;
    }

    public static KeyRequestInfo fromDOM(Element infoElement) {
        KeyRequestInfo info = new KeyRequestInfo();
        CMSRequestInfo.fromDOM(infoElement, info);
        NodeList keyURLList = infoElement.getElementsByTagName("keyURL");
        if (keyURLList.getLength() > 0) {
            String value = keyURLList.item(0).getTextContent();
            info.setKeyURL(value);
        }
        return info;
    }

    @Override
    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = this.toDOM(document);
        document.appendChild(element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static KeyRequestInfo fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element element = document.getDocumentElement();
        return KeyRequestInfo.fromDOM(element);
    }
}

