/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.apdu;

import com.netscape.certsrv.base.EBaseException;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.Util;
import org.mozilla.jss.pkcs11.PK11SymKey;

public abstract class APDU {
    public static int DEFAULT_APDU_SIZE = 32;
    protected byte cla;
    protected byte ins;
    protected byte p1;
    protected byte p2;
    protected TPSBuffer data = null;
    protected TPSBuffer plainText = null;
    protected TPSBuffer mac = null;
    protected TPSBuffer trailer = null;

    public APDU() {
        this.data = new TPSBuffer();
    }

    public APDU(APDU otherAPDU) {
        this.data = new TPSBuffer(otherAPDU.getData());
    }

    void setCLA(byte theCla) {
        this.cla = theCla;
    }

    void setINS(byte theIns) {
        this.ins = theIns;
    }

    void setP1(byte theP1) {
        this.p1 = theP1;
    }

    void setP2(byte theP2) {
        this.p2 = theP2;
    }

    void setData(TPSBuffer theData) {
        this.data = new TPSBuffer(theData);
    }

    public void setMAC(TPSBuffer theMac) {
        this.mac = theMac;
    }

    public void setTrailer(TPSBuffer theTrailer) {
        this.trailer = theTrailer;
    }

    public TPSBuffer getEncoding() {
        TPSBuffer encoding = new TPSBuffer();
        encoding.add(this.cla);
        encoding.add(this.ins);
        encoding.add(this.p1);
        encoding.add(this.p2);
        int m_mac_size = 0;
        if (this.mac != null) {
            m_mac_size = this.mac.size();
        }
        encoding.add((byte)(this.data.size() + m_mac_size));
        encoding.add(this.data);
        if (m_mac_size > 0) {
            encoding.add(this.mac);
        }
        if (this.trailer != null) {
            encoding.add(this.trailer);
        }
        return encoding;
    }

    public TPSBuffer getDataToMAC() {
        TPSBuffer mac = new TPSBuffer();
        mac.add(this.cla);
        mac.add(this.ins);
        mac.add(this.p1);
        mac.add(this.p2);
        mac.add((byte)(this.data.size() + 8));
        mac.add(this.data);
        return mac;
    }

    public void secureMessage(PK11SymKey encKey, byte protocol) throws EBaseException {
        if (encKey == null) {
            throw new EBaseException("APDU.secureData: No input encrytion session key!");
        }
        int padNeeded = 0;
        TPSBuffer dataToEnc = null;
        TPSBuffer padding = null;
        TPSBuffer dataEncrypted = null;
        dataToEnc = new TPSBuffer();
        if (protocol == 1) {
            dataToEnc.add((byte)this.data.size());
        }
        dataToEnc.add(this.data);
        int dataSize = dataToEnc.size();
        int rem = dataSize % 8;
        if (rem == 0) {
            if (protocol == 1) {
                padNeeded = 0;
            } else if (protocol == 2) {
                padNeeded = 8;
            }
        } else {
            padNeeded = dataSize < 8 ? 8 - dataSize : 8 - rem;
        }
        if (padNeeded > 0) {
            dataToEnc.add((byte)-128);
            if (--padNeeded > 0) {
                padding = new TPSBuffer(padNeeded);
                dataToEnc.add(padding);
            }
        }
        dataEncrypted = Util.encryptData(dataToEnc, encKey);
        this.data.set(dataEncrypted);
    }

    public void padBuffer80(TPSBuffer buffer, int blockSize) {
        int length = buffer.size();
        int padSize = 0;
        if (buffer == null || blockSize <= 0) {
            return;
        }
        int rem = length % blockSize;
        padSize = blockSize - rem;
        TPSBuffer padding = new TPSBuffer(padSize);
        padding.setAt(0, (byte)-128);
        buffer.add(padding);
    }

    public void incrementBuffer(TPSBuffer buffer) {
        if (buffer == null) {
            return;
        }
        int len = buffer.size();
        if (len < 1) {
            return;
        }
        short offset = 0;
        for (short i = (short)(offset + len - 1); i >= offset; i = (short)(i - 1)) {
            byte cur = buffer.at(i);
            if (cur != -1) {
                cur = (byte)(cur + 1);
                buffer.setAt(i, cur);
                break;
            }
            buffer.setAt(i, (byte)0);
        }
        System.out.println("enc buffer: " + buffer.toHexString());
    }

    public void secureMessageSCP03(PK11SymKey encKey, TPSBuffer encryptionCounter) throws EBaseException {
        TPSBuffer data = this.getData();
        if (data != null && data.size() > 0) {
            this.padBuffer80(data, 16);
            TPSBuffer encryptedCounter = Util.encryptDataAES(encryptionCounter, encKey, null);
            TPSBuffer encryptedData = Util.encryptDataAES(data, encKey, encryptedCounter);
            data.set(encryptedData);
        }
    }

    public void secureMessageSCP02(PK11SymKey encKey) throws EBaseException {
        if (encKey == null) {
            throw new EBaseException("APDU.secureDataSCP02: Invalid input data!");
        }
        this.secureMessage(encKey, (byte)2);
    }

    public Type getType() {
        return Type.APDU_UNDEFINED;
    }

    public TPSBuffer getData() {
        return this.data;
    }

    public TPSBuffer getMAC() {
        return this.mac;
    }

    public byte getCLA() {
        return this.cla;
    }

    public byte getINS() {
        return this.ins;
    }

    public byte getP1() {
        return this.p1;
    }

    public byte getP2() {
        return this.p2;
    }

    public void dump() {
        int claInt = this.cla & 0xFF;
        int insInt = this.ins & 0xFF;
        int p1Int = this.p1 & 0xFF;
        int p2Int = this.p2 & 0xFF;
        System.out.println("APDU: ");
        System.out.println("CLA: " + Util.intToHex(claInt));
        System.out.println("INS: " + Util.intToHex(insInt));
        System.out.println("P1: " + Util.intToHex(p1Int));
        System.out.println("P2: " + Util.intToHex(p2Int));
        this.data.dump();
    }

    public static enum Type {
        APDU_UNDEFINED,
        APDU_CREATE_OBJECT,
        APDU_EXTERNAL_AUTHENTICATE,
        APDU_INITIALIZE_UPDATE,
        APDU_LIFECYCLE,
        APDU_READ_BUFFER,
        APDU_SET_PIN,
        APDU_UNBLOCK_PIN,
        APDU_WRITE_OBJECT,
        APDU_GENERATE_KEY,
        APDU_PUT_KEY,
        APDU_SELECT,
        APDU_GET_VERSION,
        APDU_DELETE_FILE,
        APDU_INSTALL_APPLET,
        APDU_FORMAT_MUSCLE_APPLET,
        APDU_LOAD_FILE,
        APDU_INSTALL_LOAD,
        APDU_GET_STATUS,
        APDU_LIST_PINS,
        APDU_CREATE_PIN,
        APDU_GET_DATA,
        APDU_READ_OBJECT,
        APDU_LIST_OBJECTS,
        APDU_IMPORT_KEY,
        APDU_IMPORT_KEY_ENC,
        APDU_SET_ISSUERINFO,
        APDU_GET_ISSUERINFO,
        APDU_GENERATE_KEY_ECC,
        APDU_GET_LIFECYCLE,
        APDU_CLEAR_KEY_SLOTS;

    }
}

