/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class PKIFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        String stackTrace;
        String format = "%1$tF %1$tT [%2$s] %3$s: %4$s%5$s%n";
        Date timestamp = new Date(record.getMillis());
        String threadName = Thread.currentThread().getName();
        Level level = record.getLevel();
        String message = this.formatMessage(record);
        Throwable throwable = record.getThrown();
        if (throwable == null) {
            stackTrace = "";
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            throwable.printStackTrace(pw);
            stackTrace = sw.toString();
        }
        return String.format(format, timestamp, threadName, level, message, stackTrace);
    }

    public static void main(String[] args) {
        PKIFormatter formatter = new PKIFormatter();
        LogRecord record = new LogRecord(Level.INFO, "Log message");
        record.setSourceClassName(PKIFormatter.class.getName());
        System.out.println(formatter.format(record));
        record.setThrown(new NullPointerException());
        System.out.println(formatter.format(record));
        record.setThrown(new Exception("Message"));
        System.out.println(formatter.format(record));
    }
}

