/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.logging;

import com.netscape.certsrv.logging.ILogger;
import com.netscape.certsrv.logging.LogCategory;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.LogSource;
import com.netscape.certsrv.logging.SignedAuditEvent;
import com.netscape.cms.logging.Logger;
import com.netscape.cms.logging.SignedAuditEventFactory;
import com.netscape.cmscore.apps.CMS;
import org.slf4j.LoggerFactory;

public class SignedAuditLogger
extends Logger {
    public static org.slf4j.Logger logger = LoggerFactory.getLogger(SignedAuditLogger.class);

    public SignedAuditLogger() {
        super(new SignedAuditEventFactory(), ILogger.EV_SIGNED_AUDIT, ILogger.S_SIGNED_AUDIT, 6);
    }

    @Override
    public void log(LogCategory category, LogSource source, int level, String message, Object[] params, boolean multiline) {
        SignedAuditEvent event = (SignedAuditEvent)this.create(category, source, level, message, params, multiline);
        int start = 0;
        try {
            int i;
            while (start < message.length() && (i = message.indexOf("[", start)) >= 0) {
                int j = message.indexOf("=", i + 1);
                if (j < 0) {
                    throw new RuntimeException("Missing equal sign: " + message);
                }
                String name = message.substring(i + 1, j);
                int k = message.indexOf("]", j + 1);
                if (k < 0) {
                    throw new RuntimeException("Missing closing bracket: " + message);
                }
                String value = message.substring(j + 1, k);
                event.setAttribute(name, value);
                start = k + 1;
            }
        }
        catch (Exception e) {
            System.err.println(CMS.getUserMessage("CMS_LOG_WRITE_FAILED", event.getEventType(), e.toString(), "Audit Event Failure!"));
            throw e;
        }
        this.logQueue.log(event);
    }

    @Override
    public void log(LogEvent event) {
        String messageID = event.getMessage();
        Object[] params = event.getParameters();
        String message = CMS.getLogMessage(messageID, params);
        this.log(this.category, this.source, this.level, message, null, false);
    }

    @Override
    public void update(LogEvent event, LogSource source, int level, String message, Object[] params, boolean multiline) {
        super.update(event, source, level, message, params, multiline);
        String eventType = null;
        message = message.trim();
        int i = message.indexOf("<type=");
        if (i >= 0) {
            int j = message.indexOf(">:");
            eventType = message.substring(i + 6, j).trim();
            message = message.substring(j + 2).trim();
            logger.debug("SignedAuditLogger: event " + eventType);
        }
        event.setEventType(eventType);
        event.setMessage(message);
    }
}

