/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.notification;

import com.netscape.certsrv.notification.ENotificationException;
import com.netscape.cmscore.apps.CMS;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import netscape.net.smtp.SmtpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailNotification {
    public static Logger logger = LoggerFactory.getLogger(MailNotification.class);
    public static final String PROP_SMTP_SUBSTORE = "smtp";
    public static final String PROP_HOST = "host";
    private String mHost = null;
    private String mFrom = null;
    private String mTo = null;
    private String mSubject = null;
    private String mContent = null;
    private String mContentType = null;

    public String getHost() {
        return this.mHost;
    }

    public void setHost(String host) {
        this.mHost = host;
    }

    public void sendNotification() throws IOException, ENotificationException {
        SmtpClient sc = null;
        if (this.mHost != null && !this.mHost.equals("")) {
            logger.debug("MailNotification: sendNotification: host=" + this.mHost);
            sc = new SmtpClient(this.mHost);
        } else {
            logger.debug("MailNotification: sendNotification: host not set");
            sc = new SmtpClient();
        }
        if (this.mFrom == null || this.mFrom.equals("")) {
            logger.error("MailNotification.sendNotification: missing sender");
            throw new ENotificationException(CMS.getUserMessage("CMS_NOTIFICATION_NO_SMTP_SENDER", new String[0]));
        }
        sc.from(this.mFrom);
        if (this.mTo == null || this.mTo.equals("")) {
            logger.error("MailNotification.sendNotification: missing receiver");
            throw new ENotificationException(CMS.getUserMessage("CMS_NOTIFICATION_NO_SMTP_RECEIVER", new String[0]));
        }
        logger.info("MailNotification: mail to be sent to " + this.mTo);
        sc.to(this.mTo);
        PrintStream msgStream = sc.startMessage();
        if (this.mContentType != null) {
            msgStream.print("From: " + this.mFrom + "\n");
            msgStream.print("MIME-Version: 1.0\n");
            msgStream.print("To: " + this.mTo + "\n");
            msgStream.print(this.mSubject + "\n");
            msgStream.print(this.mContentType + "\n");
        } else {
            msgStream.print("From: " + this.mFrom + "\n");
            msgStream.print("To: " + this.mTo + "\n");
            msgStream.print(this.mSubject + "\n");
        }
        msgStream.print("\r\n");
        msgStream.print(this.mContent + "\r\n");
        try {
            sc.closeServer();
            logger.debug("MailNotification.sendNotification: after closeServer");
        }
        catch (IOException e) {
            logger.error("MailNotification: Unable to send: " + e.getMessage(), (Throwable)e);
            throw new ENotificationException(CMS.getUserMessage("CMS_NOTIFICATION_SMTP_SEND_FAILED", this.mTo));
        }
    }

    public void setFrom(String from) {
        this.mFrom = from;
    }

    public void setSubject(String subject) {
        this.mSubject = "Subject: " + subject;
    }

    public void setContentType(String contentType) {
        this.mContentType = "Content-Type: " + contentType;
    }

    public void setContent(String content) {
        this.mContent = content;
    }

    public void setTo(Vector<String> addresses) {
    }

    public void setTo(String to) {
        this.mTo = to;
    }
}

