/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.common;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenErrorTemplateFiller
implements ICMSTemplateFiller {
    public static Logger logger = LoggerFactory.getLogger(GenErrorTemplateFiller.class);

    @Override
    public CMSTemplateParams getTemplateParams(CMSRequest cmsReq, IAuthority authority, Locale locale, Exception e) {
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams params = new CMSTemplateParams(null, fixed);
        if (cmsReq != null) {
            Integer sts = cmsReq.getStatus();
            if (sts != null) {
                fixed.set("requestStatus", sts.toString());
            }
        } else {
            logger.warn("GenErrorTemplateFiller::getTemplateParams() - cmsReq is null!");
            return null;
        }
        String ex = cmsReq.getError();
        if (ex == null && cmsReq.getReason() == null) {
            ex = new EBaseException(CMS.getLogMessage("BASE_UNKNOWN_ERROR", new Object[0])).toString();
        } else if (ex != null) {
            fixed.set("errorDetails", ex);
        } else if (cmsReq.getReason() != null) {
            fixed.set("errorDetails", cmsReq.getReason());
        }
        Vector<String> descr = cmsReq.getErrorDescr();
        if (descr != null) {
            Enumeration<String> num = descr.elements();
            while (num.hasMoreElements()) {
                String elem = num.nextElement();
                ArgBlock argBlock = new ArgBlock();
                argBlock.set("errorDescription", elem);
                params.addRepeatRecord(argBlock);
            }
        }
        if (authority != null) {
            fixed.set("authorityName", authority.getOfficialName());
        }
        return params;
    }
}

