/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.authentication;

import com.netscape.cmscore.authentication.VerifiedCert;
import java.math.BigInteger;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class VerifiedCerts {
    private int mFirst = 0;
    private int mLast = 0;
    private int mNext = 0;
    private VerifiedCert[] mVCerts = null;
    private long mInterval = 0L;
    private long mUnknownStateInterval = 0L;

    public VerifiedCerts(int size, long interval) {
        this.mVCerts = new VerifiedCert[size];
        this.mInterval = interval;
        this.mUnknownStateInterval = interval;
    }

    public VerifiedCerts(int size, long interval, long unknownStateInterval) {
        this.mVCerts = new VerifiedCert[size];
        this.mInterval = interval;
        this.mUnknownStateInterval = unknownStateInterval;
    }

    public synchronized void update(X509CertImpl cert, int status) {
        if (cert != null) {
            byte[] certEncoded = null;
            try {
                certEncoded = cert.getEncoded();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((certEncoded != null || status == 4 && this.mUnknownStateInterval > 0L) && this.mInterval > 0L) {
                this.update(cert.getSerialNumber(), certEncoded, status);
            }
        }
    }

    public synchronized void update(BigInteger serialNumber, byte[] certEncoded, int status) {
        if ((status == 2 || status == 1 || status == 4 && this.mUnknownStateInterval > 0L) && this.mInterval > 0L) {
            if (this.mLast == this.mNext && this.mFirst == this.mNext) {
                this.mVCerts[this.mNext] = new VerifiedCert(serialNumber, certEncoded, status);
                this.mNext = this.next(this.mNext);
            } else if (this.mFirst == this.mNext) {
                this.mFirst = this.next(this.mFirst);
                this.mVCerts[this.mNext] = new VerifiedCert(serialNumber, certEncoded, status);
                this.mLast = this.mNext;
                this.mNext = this.next(this.mNext);
            } else {
                this.mVCerts[this.mNext] = new VerifiedCert(serialNumber, certEncoded, status);
                this.mLast = this.mNext;
                this.mNext = this.next(this.mNext);
            }
        }
    }

    public synchronized int check(X509CertImpl cert) {
        int status = 0;
        if (this.mLast != this.mNext && this.mInterval > 0L && cert != null) {
            byte[] certEncoded = null;
            try {
                certEncoded = cert.getEncoded();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (certEncoded != null) {
                status = this.check(cert.getSerialNumber(), certEncoded);
            }
        }
        return status;
    }

    public synchronized int check(BigInteger serialNumber, byte[] certEncoded) {
        int status = 0;
        int i = this.mLast;
        if (this.mVCerts != null && this.mLast != this.mNext && this.mInterval > 0L) {
            while (status == 0) {
                if (this.mVCerts[i] == null) {
                    return status;
                }
                status = this.mVCerts[i].check(serialNumber, certEncoded, this.mInterval, this.mUnknownStateInterval);
                if (status == 3) {
                    if (this.mFirst == this.mLast) {
                        this.mNext = this.mLast;
                        break;
                    }
                    this.mFirst = this.next(i);
                    break;
                }
                if (this.mFirst == i) break;
                i = this.previous(i);
            }
            if (status == 0) {
                status = this.mVCerts[i].check(serialNumber, certEncoded, this.mInterval, this.mUnknownStateInterval);
            }
        }
        return status;
    }

    private int next(int i) {
        if (++i >= this.mVCerts.length) {
            i = 0;
        }
        return i;
    }

    private int previous(int i) {
        if (i <= 0) {
            i = this.mVCerts.length;
        }
        return --i;
    }
}

