/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.cert;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.cert.CertDateCompare;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtils {
    public static Logger logger = LoggerFactory.getLogger(CertUtils.class);
    public static final String CT_POISON_OID = "1.3.6.1.4.1.11129.2.4.3";
    public static final boolean CT_POISON_CRITICAL = true;
    public static final byte[] CT_POISON_DATA = new byte[]{5, 0};

    public static DerInputStream parseKeyGen(String certreq) throws Exception {
        byte[] data = Utils.base64decode((String)certreq);
        return new DerInputStream(data);
    }

    public static void setRSAKeyToCertInfo(X509CertInfo info, byte[] encoded) throws EBaseException {
        try {
            if (info == null) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_OPERATION", new String[0]));
            }
            X509Key key = new X509Key(AlgorithmId.get((String)"RSAEncryption"), encoded);
            info.set("key", (Object)key);
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_OPERATION", new String[0]));
        }
    }

    public static void sortCerts(X509CertImpl[] arr) {
        Arrays.sort(arr, new CertDateCompare());
    }

    public static boolean isSigningCert(X509CertImpl cert) {
        boolean[] keyUsage = null;
        try {
            keyUsage = cert.getKeyUsage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keyUsage == null ? false : keyUsage[0];
    }

    public static boolean isEncryptionCert(X509CertImpl cert) {
        boolean[] keyUsage = null;
        try {
            keyUsage = cert.getKeyUsage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (keyUsage == null) {
            return false;
        }
        if (keyUsage.length < 3) {
            return false;
        }
        if (keyUsage.length == 3) {
            return keyUsage[2];
        }
        return keyUsage[2] || keyUsage[3];
    }

    public static boolean haveSameValidityPeriod(X509CertImpl cert1, X509CertImpl cert2) {
        long notBefDiff = 0L;
        long notAfterDiff = 0L;
        try {
            notBefDiff = Math.abs(cert1.getNotBefore().getTime() - cert2.getNotBefore().getTime());
            notAfterDiff = Math.abs(cert1.getNotAfter().getTime() - cert2.getNotAfter().getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notBefDiff <= 1000L && notAfterDiff <= 1000L;
    }

    public static boolean isSmimePair(X509CertImpl cert1, X509CertImpl cert2, boolean matchSubjectDN) {
        boolean hasEncryptionCert;
        boolean hasSigningCert;
        String dn2;
        String dn1;
        if (matchSubjectDN && !CertUtils.sameSubjectDN(dn1 = cert1.getSubjectName().toString(), dn2 = cert2.getSubjectName().toString())) {
            return false;
        }
        boolean bl = hasSigningCert = CertUtils.isSigningCert(cert1) || CertUtils.isSigningCert(cert2);
        if (!hasSigningCert) {
            return false;
        }
        boolean bl2 = hasEncryptionCert = CertUtils.isEncryptionCert(cert1) || CertUtils.isEncryptionCert(cert2);
        if (!hasEncryptionCert) {
            return false;
        }
        if (CertUtils.isSigningCert(cert1) && CertUtils.isEncryptionCert(cert1) || CertUtils.isSigningCert(cert2) && CertUtils.isEncryptionCert(cert2)) {
            return false;
        }
        boolean haveSameValidity = CertUtils.haveSameValidityPeriod(cert1, cert2);
        return haveSameValidity;
    }

    public static boolean isNotYetValidCert(X509CertImpl cert) {
        boolean ret = false;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
        }
        catch (CertificateNotYetValidException e) {
            ret = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean isValidCert(X509CertImpl cert) {
        boolean ret = true;
        try {
            cert.checkValidity();
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static boolean isExpiredCert(X509CertImpl cert) {
        boolean ret = false;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            ret = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean sameSubjectDN(String dn1, String dn2) {
        boolean ret = false;
        if (dn1 == null || dn2 == null) {
            return false;
        }
        try {
            X500Name n1 = new X500Name(dn1);
            X500Name n2 = new X500Name(dn2);
            ret = n1.equals((Object)n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String getValidCertsDisplayInfo(String cn, X509CertImpl[] validCerts) {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(cn + "'s Currently Valid Certificates\n\n");
        sb.append(CertUtils.getCertsDisplayInfo(validCerts));
        return new String(sb);
    }

    public static String getExpiredCertsDisplayInfo(String cn, X509CertImpl[] expiredCerts) {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(cn + "'s Expired Certificates\n\n");
        sb.append(CertUtils.getCertsDisplayInfo(expiredCerts));
        return new String(sb);
    }

    public static String getRenewedCertsDisplayInfo(String cn, X509CertImpl[] validCerts, X509CertImpl[] renewedCerts) {
        StringBuffer sb = new StringBuffer(1024);
        if (validCerts != null) {
            sb.append(cn + "'s Currently Valid Certificates\n\n");
            sb.append(CertUtils.getCertsDisplayInfo(validCerts));
            sb.append("\n\nRenewed Certificates\n\n\n");
        } else {
            sb.append(cn + "'s Renewed Certificates\n\n");
        }
        sb.append(CertUtils.getCertsDisplayInfo(renewedCerts));
        return new String(sb);
    }

    public static String getCertsDisplayInfo(X509CertImpl[] validCerts) {
        X509CertImpl encryptionCert;
        X509CertImpl signingCert;
        StringBuffer sb = new StringBuffer(1024);
        sb.append("Subject DN: " + validCerts[0].getSubjectName().toString());
        sb.append("\n");
        if (CertUtils.isSigningCert(validCerts[0])) {
            signingCert = validCerts[0];
            encryptionCert = validCerts[1];
        } else {
            signingCert = validCerts[1];
            encryptionCert = validCerts[0];
        }
        sb.append("Signing      Certificate Serial No: " + signingCert.getSerialNumber().toString(16).toUpperCase());
        sb.append("\n");
        sb.append("Encryption Certificate Serial No: " + encryptionCert.getSerialNumber().toString(16).toUpperCase());
        sb.append("\n");
        sb.append("Validity: From: " + signingCert.getNotBefore().toString() + "  To: " + signingCert.getNotAfter().toString());
        sb.append("\n");
        return new String(sb);
    }

    public static int getCertIndex(X509CertImpl[] certArray, X509CertImpl givenCert) {
        int i;
        for (i = 0; i < certArray.length && !certArray[i].getSerialNumber().equals(givenCert.getSerialNumber()); ++i) {
        }
        return i == certArray.length ? -1 : i;
    }

    public static X509CertImpl getRecentSigningCert(X509CertImpl[] certArray, X509CertImpl currentCert) {
        int i;
        if (certArray == null || currentCert == null) {
            return null;
        }
        Arrays.sort(certArray, new CertDateCompare());
        if (i < 0) {
            return null;
        }
        X509CertImpl recentCert = currentCert;
        for (i = CertUtils.getCertIndex(certArray, currentCert); i < certArray.length; ++i) {
            if (!CertUtils.isSigningCert(certArray[i]) || !certArray[i].getNotAfter().after(recentCert.getNotAfter())) continue;
            recentCert = certArray[i];
        }
        return recentCert == currentCert ? null : recentCert;
    }

    public static String getCertType(X509CertImpl cert) throws CertificateParsingException, IOException {
        String nsType;
        NSCertTypeExtension nsExtn;
        CertificateExtensions extns;
        StringBuffer sb = new StringBuffer();
        if (CertUtils.isSigningCert(cert)) {
            sb.append("signing");
        }
        if (CertUtils.isEncryptionCert(cert)) {
            if (sb.length() > 0) {
                sb.append("  ");
            }
            sb.append("encryption");
        }
        if ((extns = (CertificateExtensions)cert.get("x509.info.extensions")) != null && (nsExtn = (NSCertTypeExtension)extns.get("NSCertType")) != null && (nsType = CertUtils.getNSExtensionInfo(nsExtn)) != null) {
            if (sb.length() > 0) {
                sb.append("  ");
            }
            sb.append(nsType);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static String getNSExtensionInfo(NSCertTypeExtension nsExtn) {
        StringBuffer sb = new StringBuffer();
        try {
            Boolean res = (Boolean)nsExtn.get("ssl_client");
            if (res.equals(Boolean.TRUE)) {
                sb.append("   ssl_client");
            }
            if ((res = (Boolean)nsExtn.get("ssl_server")).equals(Boolean.TRUE)) {
                sb.append("   ssl_server");
            }
            if ((res = (Boolean)nsExtn.get("email")).equals(Boolean.TRUE)) {
                sb.append("   email");
            }
            if ((res = (Boolean)nsExtn.get("object_signing")).equals(Boolean.TRUE)) {
                sb.append("   object_signing");
            }
            if ((res = (Boolean)nsExtn.get("ssl_ca")).equals(Boolean.TRUE)) {
                sb.append("   ssl_CA");
            }
            if ((res = (Boolean)nsExtn.get("email_ca")).equals(Boolean.TRUE)) {
                sb.append("   email_CA");
            }
            if ((res = (Boolean)nsExtn.get("object_signing_ca")).equals(Boolean.TRUE)) {
                sb.append("   object_signing_CA");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFromFile(String fileName) throws IOException {
        try (FileInputStream fin = null;){
            fin = new FileInputStream(fileName);
            int available = fin.available();
            byte[] ba = new byte[available];
            int nRead = fin.read(ba);
            if (nRead != available) {
                throw new IOException("Error reading data from file: " + fileName);
            }
            byte[] byArray = ba;
            return byArray;
        }
    }

    public static void storeInFile(String fileName, byte[] ba) throws IOException {
        try (FileOutputStream fout = null;){
            fout = new FileOutputStream(fileName);
            fout.write(ba);
        }
    }

    public static X509Certificate mapCert(String mime64) throws IOException {
        mime64 = CertUtils.stripCertBrackets(mime64.trim());
        String newval = CertUtils.normalizeCertStr(mime64);
        byte[] rawPub = Utils.base64decode((String)newval);
        X509CertImpl cert = null;
        try {
            cert = new X509CertImpl(rawPub);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return cert;
    }

    public static X509Certificate[] mapCertFromPKCS7(String mime64) throws IOException {
        mime64 = CertUtils.stripCertBrackets(mime64.trim());
        String newval = CertUtils.normalizeCertStr(mime64);
        byte[] rawPub = Utils.base64decode((String)newval);
        PKCS7 p7 = null;
        try {
            p7 = new PKCS7(rawPub);
            return p7.getCertificates();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public static X509CRL mapCRL(String mime64) throws IOException {
        mime64 = CertUtils.stripCRLBrackets(mime64.trim());
        String newval = CertUtils.normalizeCertStr(mime64);
        byte[] rawPub = Utils.base64decode((String)newval);
        X509CRLImpl crl = null;
        try {
            crl = new X509CRLImpl(rawPub);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return crl;
    }

    public static X509CRL mapCRL1(String mime64) throws IOException {
        mime64 = CertUtils.stripCRLBrackets(mime64.trim());
        byte[] rawPub = Utils.base64decode((String)mime64);
        X509CRLImpl crl = null;
        try {
            crl = new X509CRLImpl(rawPub);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        return crl;
    }

    public static String normalizeCertStr(String s) {
        StringBuffer val = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\r' || s.charAt(i) == '\"' || s.charAt(i) == ' ') continue;
            val.append(s.charAt(i));
        }
        return val.toString();
    }

    public static String stripCRLBrackets(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("-----BEGIN CERTIFICATE REVOCATION LIST-----") && s.endsWith("-----END CERTIFICATE REVOCATION LIST-----")) {
            return s.substring(43, s.length() - 41);
        }
        return s;
    }

    public static String stripCertBrackets(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("-----BEGIN CERTIFICATE-----") && s.endsWith("-----END CERTIFICATE-----")) {
            return s.substring(27, s.length() - 25);
        }
        if (s.startsWith("-----BEGIN PKCS #7 SIGNED DATA-----") && s.endsWith("-----END PKCS #7 SIGNED DATA-----")) {
            return s.substring(35, s.length() - 33);
        }
        return s;
    }

    public static String getFingerPrint(Certificate cert) throws CertificateEncodingException, NoSuchAlgorithmException {
        byte[] certDer = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(certDer);
        byte[] digestedCert = md.digest();
        PrettyPrintFormat pp = new PrettyPrintFormat(":");
        StringBuffer sb = new StringBuffer();
        sb.append(pp.toHexString(digestedCert, 4, 20));
        return sb.toString();
    }

    public static String getFingerPrints(Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        byte[] certDer = cert.getEncoded();
        return CertUtils.getFingerPrints(certDer);
    }

    public static String getFingerPrints(byte[] certDer) throws NoSuchAlgorithmException {
        String[] hashes = new String[]{"MD2", "MD5", "SHA1", "SHA256", "SHA512"};
        StringBuffer certFingerprints = new StringBuffer();
        PrettyPrintFormat pp = new PrettyPrintFormat(":");
        for (int i = 0; i < hashes.length; ++i) {
            MessageDigest md = MessageDigest.getInstance(hashes[i]);
            md.update(certDer);
            certFingerprints.append(hashes[i] + ":\n" + pp.toHexString(md.digest(), 8, 16));
        }
        return certFingerprints.toString();
    }

    public static ObjectIdentifier checkOID(String attrName, String value) throws EBaseException {
        ObjectIdentifier oid;
        String msg = "value must be a object identifier in the form n.n.n.n";
        String msg1 = "not a valid object identifier.";
        try {
            oid = ObjectIdentifier.getObjectIdentifier((String)value);
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", attrName, msg));
        }
        DerOutputStream derOut = null;
        try {
            derOut = new DerOutputStream();
            derOut.putOID(oid);
            new ObjectIdentifier(new DerInputStream(derOut.toByteArray()));
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", attrName, msg1));
        }
        finally {
            try {
                derOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return oid;
    }

    public static String trimB64E(String b64e) {
        StringBuffer tmp = new StringBuffer("");
        String line = null;
        StringTokenizer tokens = new StringTokenizer(b64e, "\n");
        while (tokens.hasMoreTokens()) {
            line = tokens.nextToken();
            line = line.trim();
            tmp.append(line.trim());
            if (!tokens.hasMoreTokens()) continue;
            tmp.append("\n");
        }
        return tmp.toString();
    }

    public static void addCTv1PoisonExt(X509CertInfo certinfo) throws CertificateException, IOException, EBaseException {
        String method = "CryptoUtil:addCTv1PoisonExt: ";
        ObjectIdentifier ct_poison_oid = new ObjectIdentifier(CT_POISON_OID);
        Extension ct_poison_ext = null;
        CertificateExtensions exts = null;
        exts = (CertificateExtensions)certinfo.get("extensions");
        if (exts == null) {
            logger.debug(method + " X509CertInfo.EXTENSIONS not found inf cetinfo");
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INTERNAL_ERROR", " X509CertInfo.EXTENSIONS not found inf cetinfo"));
        }
        DerOutputStream out = new DerOutputStream();
        out.putOctetString(CT_POISON_DATA);
        ct_poison_ext = new Extension(ct_poison_oid, true, out.toByteArray());
        certinfo.set("extensions", (Object)exts);
        exts.set(CT_POISON_OID, (Object)ct_poison_ext);
        certinfo.delete("extensions");
        certinfo.set("extensions", (Object)exts);
    }

    public static void printExtensions(CertificateExtensions exts) {
        String method = "CryptoUtil.printExtensions: ";
        System.out.println(method + "begins");
        try {
            if (exts == null) {
                return;
            }
            Enumeration e = exts.getNames();
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                Extension ext = (Extension)exts.get(n);
                System.out.println(" ---- " + ext.getExtensionId().toString());
            }
        }
        catch (Exception e) {
            System.out.println(method + e.toString());
        }
        System.out.println(method + "ends");
    }

    public static byte[] intToFixedWidthBytes(int n, int width) {
        byte[] out = new byte[width];
        for (int i = 0; i < width; ++i) {
            out[i] = (byte)(n >> (width - i - 1) * 8);
        }
        return out;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static boolean certInCertChain(X509Certificate[] certChain, X509Certificate cert) {
        for (X509Certificate c : certChain) {
            if (!cert.equals(c)) continue;
            return true;
        }
        return false;
    }
}

