/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.session;

import com.netscape.certsrv.base.SecurityDomainSessionTable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MemorySecurityDomainSessionTable
extends SecurityDomainSessionTable {
    private Hashtable<String, Vector<Comparable<?>>> m_sessions;

    public MemorySecurityDomainSessionTable(long timeToLive) {
        this.timeToLive = timeToLive;
        this.m_sessions = new Hashtable();
    }

    public void addEntry(String sessionId, String ip, String uid, String group) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(ip);
        v.addElement(uid);
        v.addElement(group);
        Date d = new Date();
        long t = d.getTime();
        v.addElement(t);
        this.m_sessions.put(sessionId, v);
    }

    public void removeEntry(String sessionId) {
        this.m_sessions.remove(sessionId);
    }

    public boolean sessionExists(String sessionId) {
        return this.m_sessions.containsKey(sessionId);
    }

    public Enumeration<String> getSessionIDs() {
        return this.m_sessions.keys();
    }

    public String getIP(String sessionId) {
        Vector<Comparable<?>> v = this.m_sessions.get(sessionId);
        if (v != null) {
            return (String)((Object)v.elementAt(0));
        }
        return null;
    }

    public String getUID(String sessionId) {
        Vector<Comparable<?>> v = this.m_sessions.get(sessionId);
        if (v != null) {
            return (String)((Object)v.elementAt(1));
        }
        return null;
    }

    public String getGroup(String sessionId) {
        Vector<Comparable<?>> v = this.m_sessions.get(sessionId);
        if (v != null) {
            return (String)((Object)v.elementAt(2));
        }
        return null;
    }

    public long getBeginTime(String sessionId) {
        Long n;
        Vector<Comparable<?>> v = this.m_sessions.get(sessionId);
        if (v != null && (n = (Long)v.elementAt(3)) != null) {
            return n;
        }
        return -1L;
    }

    public int getSize() {
        return this.m_sessions.size();
    }

    public void shutdown() {
    }
}

