/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.cms.servlet.csadmin.LDAPConfigurator;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import netscape.ldap.LDAPSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemDBRemoveCLI
extends SubsystemCLI {
    public static Logger logger = LoggerFactory.getLogger(SubsystemDBRemoveCLI.class);

    public SubsystemDBRemoveCLI(CLI parent) {
        super("remove", "Remove " + parent.getParent().getName().toUpperCase() + " database", parent);
    }

    public void createOptions() {
        Option option = new Option("d", true, "NSS database location");
        option.setArgName("database");
        this.options.addOption(option);
        option = new Option("f", true, "NSS database password configuration");
        option.setArgName("password config");
        this.options.addOption(option);
        this.options.addOption(null, "force", false, "Force");
        this.options.addOption("v", "verbose", false, "Run in verbose mode.");
        this.options.addOption(null, "debug", false, "Run in debug mode.");
        this.options.addOption(null, "help", false, "Show help message.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        this.initializeTomcatJSS();
        String subsystem = this.parent.getParent().getName();
        EngineConfig cs = this.getEngineConfig(subsystem);
        cs.load();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        String database = ldapConfig.getDatabase();
        String baseDN = ldapConfig.getBaseDN();
        logger.info("Removing database " + database);
        if (!cmd.hasOption("force")) {
            System.out.println("WARNING: This command will remove the " + database + " database that contains the " + baseDN + " subtree.");
            System.out.println();
            System.out.print("Are you sure (y/N)? ");
            System.out.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            if (!line.equalsIgnoreCase("Y")) {
                return;
            }
        }
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        LDAPConnectionConfig connConfig = ldapConfig.getConnectionConfig();
        LdapConnInfo connInfo = new LdapConnInfo(connConfig);
        LdapAuthInfo authInfo = this.getAuthInfo(passwordStore, connInfo, ldapConfig);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PKISocketFactory socketFactory = new PKISocketFactory();
        socketFactory.setSecure(connInfo.getSecure());
        if (authInfo.getAuthType() == 2) {
            socketFactory.setClientCertNickname(authInfo.getClientCertNickname());
        }
        socketFactory.init(socketConfig);
        LdapBoundConnection conn = new LdapBoundConnection((LDAPSocketFactory)socketFactory, connInfo, authInfo);
        LDAPConfigurator ldapConfigurator = new LDAPConfigurator(conn, ldapConfig);
        try {
            ldapConfigurator.deleteDatabase(database, baseDN);
        }
        finally {
            conn.disconnect();
        }
    }
}

