/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.account.Account;
import com.netscape.certsrv.acls.ACLMapping;
import com.netscape.certsrv.authentication.AuthMethodMapping;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.usrgrp.User;
import java.security.Principal;
import java.util.Arrays;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="account")
@AuthMethodMapping(value="account")
public class AccountService
extends PKIService {
    public static Logger logger = LoggerFactory.getLogger(AccountService.class);

    protected Account createAccount() {
        Principal principal = this.servletRequest.getUserPrincipal();
        logger.info("Principal:");
        Account account = new Account();
        String name = principal.getName();
        logger.info("- ID: " + name);
        account.setID(name);
        if (principal instanceof PKIPrincipal) {
            PKIPrincipal pkiPrincipal = (PKIPrincipal)((Object)principal);
            User user = pkiPrincipal.getUser();
            String fullName = user.getFullName();
            logger.info("- Full Name: " + fullName);
            if (!StringUtils.isEmpty((CharSequence)fullName)) {
                account.setFullName(fullName);
            }
            String email = user.getEmail();
            logger.info("- Email: " + email);
            if (!StringUtils.isEmpty((CharSequence)email)) {
                account.setEmail(email);
            }
        }
        if (principal instanceof GenericPrincipal) {
            String[] roles = ((GenericPrincipal)principal).getRoles();
            logger.info("Roles:");
            for (String role : roles) {
                logger.info("- " + role);
            }
            account.setRoles(Arrays.asList(roles));
        }
        return account;
    }

    @GET
    @Path(value="login")
    @ACLMapping(value="account.login")
    public Response login() {
        HttpSession session = this.servletRequest.getSession();
        logger.info("Creating session " + session.getId());
        Account account = this.createAccount();
        return this.createOKResponse(account);
    }

    @GET
    @Path(value="logout")
    @ACLMapping(value="account.logout")
    public Response logout() {
        HttpSession session = this.servletRequest.getSession(false);
        if (session == null) {
            return this.createNoContentResponse();
        }
        logger.info("Destroying session " + session.getId());
        session.invalidate();
        return this.createNoContentResponse();
    }
}

