/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.key.KeyClient;
import com.netscape.certsrv.key.KeyInfo;
import com.netscape.certsrv.key.KeyRequestInfo;
import com.netscape.certsrv.util.CryptoProvider;
import com.netscape.certsrv.util.NSSCryptoProvider;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.cli.SubsystemCLI;
import com.netscape.cmstools.kra.KRAKeyArchiveCLI;
import com.netscape.cmstools.kra.KRAKeyFindCLI;
import com.netscape.cmstools.kra.KRAKeyGenerateCLI;
import com.netscape.cmstools.kra.KRAKeyModifyCLI;
import com.netscape.cmstools.kra.KRAKeyRecoverCLI;
import com.netscape.cmstools.kra.KRAKeyRequestFindCLI;
import com.netscape.cmstools.kra.KRAKeyRequestReviewCLI;
import com.netscape.cmstools.kra.KRAKeyRequestShowCLI;
import com.netscape.cmstools.kra.KRAKeyRetrieveCLI;
import com.netscape.cmstools.kra.KRAKeyShowCLI;
import com.netscape.cmstools.kra.KRAKeyTemplateFindCLI;
import com.netscape.cmstools.kra.KRAKeyTemplateShowCLI;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.kra.KRASystemCertClient;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyCLI.class);
    public KeyClient keyClient;

    public KRAKeyCLI(CLI parent) {
        super("key", "Key management commands", parent);
        this.addModule((CLI)new KRAKeyTemplateFindCLI(this));
        this.addModule((CLI)new KRAKeyTemplateShowCLI(this));
        this.addModule((CLI)new KRAKeyRequestFindCLI(this));
        this.addModule((CLI)new KRAKeyRequestShowCLI(this));
        this.addModule((CLI)new KRAKeyRequestReviewCLI(this));
        this.addModule((CLI)new KRAKeyFindCLI(this));
        this.addModule((CLI)new KRAKeyShowCLI(this));
        this.addModule((CLI)new KRAKeyModifyCLI(this));
        this.addModule((CLI)new KRAKeyGenerateCLI(this));
        this.addModule((CLI)new KRAKeyArchiveCLI(this));
        this.addModule((CLI)new KRAKeyRetrieveCLI(this));
        this.addModule((CLI)new KRAKeyRecoverCLI(this));
    }

    public String getFullName() {
        return this.parent instanceof MainCLI ? this.name : this.parent.getFullName() + "-" + this.name;
    }

    public String getManPage() {
        return "pki-key";
    }

    public KeyClient getKeyClient() throws Exception {
        return this.getKeyClient(null);
    }

    public KeyClient getKeyClient(String transportNickname) throws Exception {
        X509Certificate transportCert;
        String subsystem;
        if (this.keyClient != null) {
            return this.keyClient;
        }
        PKIClient client = this.getClient();
        if (this.parent instanceof SubsystemCLI) {
            SubsystemCLI subsystemCLI = (SubsystemCLI)this.parent;
            subsystem = subsystemCLI.getName();
        } else {
            subsystem = "kra";
        }
        this.keyClient = new KeyClient(client, subsystem);
        this.keyClient.setCrypto((CryptoProvider)new NSSCryptoProvider(client.getConfig()));
        CryptoManager manager = CryptoManager.getInstance();
        if (transportNickname == null) {
            KRASystemCertClient systemCertClient = new KRASystemCertClient(client, subsystem);
            String pemCert = systemCertClient.getTransportCert().getEncoded();
            String b64Cert = pemCert.substring("-----BEGIN CERTIFICATE-----".length(), pemCert.indexOf("-----END CERTIFICATE-----"));
            byte[] binCert = Utils.base64decode((String)b64Cert);
            transportCert = manager.importCACertPackage(binCert);
        } else {
            transportCert = manager.findCertByNickname(transportNickname);
        }
        logger.info("Transport cert: " + transportCert.getNickname());
        this.keyClient.setTransportCert(transportCert);
        return this.keyClient;
    }

    public static void printKeyInfo(KeyInfo info) {
        System.out.println("  Key ID: " + info.getKeyId().toHexString());
        if (info.getClientKeyID() != null) {
            System.out.println("  Client Key ID: " + info.getClientKeyID());
        }
        if (info.getStatus() != null) {
            System.out.println("  Status: " + info.getStatus());
        }
        if (info.getAlgorithm() != null) {
            System.out.println("  Algorithm: " + info.getAlgorithm());
        }
        if (info.getSize() != null) {
            System.out.println("  Size: " + info.getSize());
        }
        if (info.getOwnerName() != null) {
            System.out.println("  Owner: " + info.getOwnerName());
        }
        if (info.getRealm() != null) {
            System.out.println("  Realm: " + info.getRealm());
        }
        if (info.getPublicKey() != null) {
            System.out.println("  Public Key: \n");
            String publicKey = Utils.base64encode((byte[])info.getPublicKey(), (boolean)true);
            System.out.println(publicKey);
            System.out.println();
        }
    }

    public static void printKeyRequestInfo(KeyRequestInfo info) {
        System.out.println("  Request ID: " + info.getRequestID().toHexString());
        if (info.getKeyId() != null) {
            System.out.println("  Key ID: " + info.getKeyId().toHexString());
        }
        if (info.getRequestType() != null) {
            System.out.println("  Type: " + info.getRequestType());
        }
        if (info.getRequestStatus() != null) {
            System.out.println("  Status: " + info.getRequestStatus());
        }
        if (info.getRealm() != null) {
            System.out.println("  Realm: " + info.getRealm());
        }
        System.out.println("  Creation Time: " + info.getCreationTime());
        System.out.println("  Modification Time: " + info.getModificationTime());
    }
}

