/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.system;

import com.netscape.certsrv.ca.CAClient;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.system.ConnectorNotFoundException;
import com.netscape.certsrv.system.KRAConnectorClient;
import com.netscape.certsrv.system.KRAConnectorInfo;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.system.KRAConnectorCLI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;

public class KRAConnectorAddCLI
extends CommandCLI {
    public KRAConnectorCLI kraConnectorCLI;

    public KRAConnectorAddCLI(KRAConnectorCLI kraConnectorCLI) {
        super("add", "Add KRA Connector", (CLI)kraConnectorCLI);
        this.kraConnectorCLI = kraConnectorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " --input-file <file> | --host <KRA host> --port <KRA port>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "host", true, "KRA host");
        option.setArgName("host");
        this.options.addOption(option);
        option = new Option(null, "port", true, "KRA port");
        option.setArgName("port");
        this.options.addOption(option);
        option = new Option(null, "input-file", true, "Input file");
        option.setArgName("input-file");
        this.options.addOption(option);
        option = new Option(null, "url", true, "Connector URL");
        option.setArgName("URL");
        this.options.addOption(option);
        option = new Option(null, "subsystem-cert", true, "Subsystem certificate path");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "transport-cert", true, "Transport certificate path");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "transport-nickname", true, "Transport certificate nickname");
        option.setArgName("nickname");
        this.options.addOption(option);
        option = new Option(null, "enable", true, "Enable (default: true)");
        option.setArgName("boolean");
        this.options.addOption(option);
        option = new Option(null, "local", true, "Local (default: false)");
        option.setArgName("boolean");
        this.options.addOption(option);
        option = new Option(null, "timeout", true, "Timeout (default: 30)");
        option.setArgName("seconds");
        this.options.addOption(option);
        option = new Option(null, "session", true, "Session ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "install-token", true, "Install token");
        option.setArgName("path");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String transportNickname;
        String transportCertPath;
        String subsystemCertPath;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String kraHost = cmd.getOptionValue("host");
        String kraPort = cmd.getOptionValue("port");
        String inputFile = cmd.getOptionValue("input-file");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        KRAConnectorClient kraConnectorClient = this.kraConnectorCLI.getKRAConnectorClient();
        if (inputFile != null) {
            try {
                KRAConnectorInfo info = kraConnectorClient.getConnectorInfo();
                logger.info("KRA connector:");
                logger.info("- host: " + info.getHost());
                logger.info("- port: " + info.getPort());
                logger.info("- path: " + info.getUri());
                throw new Exception("Cannot add new connector from file.  Delete the existing connector first");
            }
            catch (ConnectorNotFoundException info) {
                String xml = new String(Files.readAllBytes(Paths.get(inputFile, new String[0])));
                KRAConnectorInfo info2 = (KRAConnectorInfo)JSONSerializer.fromJSON((String)xml, KRAConnectorInfo.class);
                kraConnectorClient.addConnector(info2);
                MainCLI.printMessage("Added KRA connector");
                return;
            }
        }
        if (kraHost != null || kraPort != null) {
            try {
                KRAConnectorInfo info = kraConnectorClient.getConnectorInfo();
                logger.info("KRA connector:");
                logger.info("- host: " + info.getHost());
                logger.info("- port: " + info.getPort());
                logger.info("- path: " + info.getUri());
            }
            catch (ConnectorNotFoundException e) {
                throw new Exception("Cannot add new host to existing connector.  No connector currently exists");
            }
            kraConnectorClient.addHost(kraHost, kraPort);
            MainCLI.printMessage("Added KRA host \"" + kraHost + ":" + kraPort + "\"");
            return;
        }
        String installToken = cmd.getOptionValue("install-token");
        String sessionID = installToken != null ? new String(Files.readAllBytes(Paths.get(installToken, new String[0]))) : cmd.getOptionValue("session");
        if (sessionID == null) {
            throw new Exception("Missing session ID or install token");
        }
        KRAConnectorInfo info = new KRAConnectorInfo();
        String connectorURL = cmd.getOptionValue("url");
        if (connectorURL != null) {
            URL url = new URL(connectorURL);
            info.setHost(url.getHost());
            info.setPort("" + url.getPort());
            info.setUri(url.getPath());
        }
        if ((subsystemCertPath = cmd.getOptionValue("subsystem-cert")) != null) {
            String subsystemCert = new String(Files.readAllBytes(Paths.get(subsystemCertPath, new String[0])));
            info.setSubsystemCert(subsystemCert);
        }
        if ((transportCertPath = cmd.getOptionValue("transport-cert")) != null) {
            String transportCert = new String(Files.readAllBytes(Paths.get(transportCertPath, new String[0])));
            info.setTransportCert(transportCert);
        }
        if ((transportNickname = cmd.getOptionValue("transport-nickname")) != null) {
            info.setTransportCertNickname(transportNickname);
        }
        String enable = cmd.getOptionValue("enable", "true");
        info.setEnable(enable);
        String local = cmd.getOptionValue("local", "false");
        info.setLocal(local);
        String timeout = cmd.getOptionValue("timeout", "30");
        info.setTimeout(timeout);
        PKIClient client = mainCLI.getClient();
        CAClient caClient = new CAClient(client);
        caClient.addKRAConnector(info, sessionID);
    }
}

