/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tks;

import com.netscape.certsrv.system.TPSConnectorClient;
import com.netscape.certsrv.system.TPSConnectorData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tks.TPSConnectorCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSConnectorAddCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TPSConnectorAddCLI.class);
    public TPSConnectorCLI tpsConnectorCLI;

    public TPSConnectorAddCLI(TPSConnectorCLI tpsConnectorCLI) {
        super("add", "Add TPS connector to TKS", (CLI)tpsConnectorCLI);
        this.tpsConnectorCLI = tpsConnectorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "host", true, "TPS host");
        option.setArgName("host");
        this.options.addOption(option);
        option = new Option(null, "port", true, "TPS port");
        option.setArgName("port");
        this.options.addOption(option);
        option = new Option(null, "output-format", true, "Output format: text (default), json");
        option.setArgName("format");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String tpsHost = cmd.getOptionValue("host");
        String tpsPort = cmd.getOptionValue("port");
        String outputFormat = cmd.getOptionValue("output-format", "text");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        TPSConnectorClient tpsConnectorClient = this.tpsConnectorCLI.getTPSConnectorClient();
        TPSConnectorData data = tpsConnectorClient.createConnector(tpsHost, tpsPort);
        if ("json".equalsIgnoreCase(outputFormat)) {
            System.out.println(data.toJSON());
        } else {
            MainCLI.printMessage("Added TPS connector \"" + tpsHost + ":" + tpsPort + "\"");
        }
    }
}

