/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.kra.KRACertCLI;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.kra.KRASystemCertClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRACertTransportShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRACertTransportShowCLI.class);
    public KRACertCLI certCLI;

    public KRACertTransportShowCLI(KRACertCLI certCLI) {
        super("transport-show", "Show KRA transport certificate", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        PKIClient client = this.getClient();
        KRASystemCertClient certClient = new KRASystemCertClient(client, "kra");
        CertData certData = certClient.getTransportCert();
        System.out.println("  Serial Number: " + certData.getSerialNumber().toHexString());
        System.out.println("  Subject DN: " + certData.getSubjectDN());
        System.out.println("  Issuer DN: " + certData.getIssuerDN());
        System.out.println("  Not Valid Before: " + certData.getNotBefore());
        System.out.println("  Not Valid After: " + certData.getNotAfter());
    }
}

