/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.system;

import com.netscape.certsrv.system.SecurityDomainClient;
import com.netscape.certsrv.system.SecurityDomainHost;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.system.SecurityDomainHostCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;

public class SecurityDomainHostAddCLI
extends CommandCLI {
    public SecurityDomainHostCLI securityDomainHostCLI;

    public SecurityDomainHostAddCLI(SecurityDomainHostCLI securityDomainHostCLI) {
        super("add", "Add security domain host", (CLI)securityDomainHostCLI);
        this.securityDomainHostCLI = securityDomainHostCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <Host ID>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "port", true, "Port (default: 8080)");
        option.setArgName("port");
        this.options.addOption(option);
        option = new Option(null, "securePort", true, "Secure port (default: 8443)");
        option.setArgName("port");
        this.options.addOption(option);
        option = new Option(null, "domainManager", true, "Domain manager (default: FALSE)");
        option.setArgName("boolean");
        this.options.addOption(option);
        option = new Option(null, "clone", true, "Clone (default: FALSE)");
        option.setArgName("boolean");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing host ID");
        }
        String hostID = cmdArgs[0];
        SecurityDomainHost host = new SecurityDomainHost();
        host.setId(hostID);
        String port = cmd.getOptionValue("port", "8080");
        host.setPort(port);
        String securePort = cmd.getOptionValue("securePort", "8443");
        host.setSecureEEClientAuthPort(securePort);
        host.setSecureAdminPort(securePort);
        host.setSecureAgentPort(securePort);
        String domainManager = cmd.getOptionValue("domainManager", "FALSE");
        host.setDomainManager(domainManager);
        String clone = cmd.getOptionValue("clone", "FALSE");
        host.setClone(clone);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        SecurityDomainClient securityDomainClient = this.securityDomainHostCLI.getSecurityDomainClient();
        securityDomainClient.addHost(host);
    }
}

