/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.common;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.common.CMSFile;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cmscore.base.ConfigStore;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class CMSFileLoader {
    public final int MAX_SIZE = 200;
    public final int CLEAR_SIZE = 50;
    public final String PROP_MAX_SIZE = "maxSize";
    public final String PROP_CLEAR_SIZE = "clearSize";
    public final String PROP_CACHE_TEMPLATES_ONLY = "cacheTemplatesOnly";
    private Hashtable<String, CMSFile> mLoadedFiles = new Hashtable();
    private int mMaxSize = 200;
    private int mClearSize = 50;
    private boolean mCacheTemplatesOnly = true;

    public void init(ConfigStore config) throws EBaseException {
        this.mMaxSize = config.getInteger("maxSize", 200);
        this.mClearSize = config.getInteger("clearSize", 50);
        this.mCacheTemplatesOnly = config.getBoolean("cacheTemplatesOnly", true);
    }

    public byte[] get(String absPath, String enc) throws EBaseException, IOException {
        File file = new File(absPath);
        return this.get(file, enc);
    }

    public byte[] get(File file, String enc) throws EBaseException, IOException {
        CMSFile cmsFile = this.getCMSFile(file, enc);
        return cmsFile.getContent();
    }

    public CMSFile getCMSFile(File file, String enc) throws EBaseException, IOException {
        long lastModified;
        String absPath = file.getAbsolutePath();
        long modified = file.lastModified();
        CMSFile cmsFile = this.mLoadedFiles.get(absPath);
        long l = lastModified = cmsFile == null ? 0L : cmsFile.getLastModified();
        if (cmsFile == null || modified != lastModified) {
            cmsFile = this.updateFile(absPath, file, enc);
        }
        cmsFile.setLastAccess(System.currentTimeMillis());
        return cmsFile;
    }

    private CMSFile updateFile(String absPath, File file, String enc) throws EBaseException, IOException {
        if (this.mLoadedFiles.size() >= this.mMaxSize) {
            this.clearSomeFiles();
        }
        CMSFile cmsFile = null;
        cmsFile = absPath.endsWith(".template") ? new CMSTemplate(file, enc) : new CMSFile(file);
        this.mLoadedFiles.put(absPath, cmsFile);
        return cmsFile;
    }

    private synchronized void clearSomeFiles() {
        if (this.mLoadedFiles.size() < this.mMaxSize) {
            return;
        }
        Enumeration<CMSFile> elements = this.mLoadedFiles.elements();
        for (int i = this.mClearSize; i > 0; --i) {
            long lru = Long.MAX_VALUE;
            CMSFile lruFile = null;
            while (elements.hasMoreElements()) {
                CMSFile cmsFile = elements.nextElement();
                if (cmsFile.getLastAccess() < lru) {
                    lruFile = cmsFile;
                }
                this.mLoadedFiles.remove(lruFile.getAbsPath());
            }
        }
    }
}

