/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.notification;

import com.netscape.cmscore.apps.CMS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailTemplate {
    public static Logger logger = LoggerFactory.getLogger(EmailTemplate.class);
    private String mTemplateFile = "";
    public String mFileContents;

    public EmailTemplate(String templatePath) {
        this.mTemplateFile = templatePath;
    }

    public boolean init() {
        FileReader input;
        File template = new File(this.mTemplateFile);
        if (!template.exists() || !template.canRead() || template.isDirectory()) {
            logger.warn(CMS.getLogMessage("CMSCORE_NOTIFY_TEMPLATE_NOT_EXIST", this.mTemplateFile));
            return false;
        }
        try {
            input = new FileReader(template);
        }
        catch (FileNotFoundException e) {
            logger.warn(CMS.getLogMessage("CMSCORE_NOTIFY_TEMPLATE_NOT_FOUND", this.mTemplateFile), (Throwable)e);
            return false;
        }
        this.mFileContents = this.loadFile(input);
        if (this.mFileContents == null) {
            logger.warn(CMS.getLogMessage("CMSCORE_NOTIFY_TEMPLATE_LOAD_ERROR", new Object[0]));
            return false;
        }
        try {
            input.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public String getTemplateName() {
        return this.mTemplateFile;
    }

    public boolean isHTML() {
        return this.mTemplateFile.endsWith(".html") || this.mTemplateFile.endsWith(".HTML") || this.mTemplateFile.endsWith(".htm") || this.mTemplateFile.endsWith(".HTM");
    }

    public String toString() {
        return this.mFileContents;
    }

    private String loadFile(FileReader input) {
        BufferedReader in = new BufferedReader(input);
        StringBuffer buf = new StringBuffer();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append("\n");
            }
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage("CMSCORE_NOTIFY_TEMPLATE_LOADING", new Object[0]), (Throwable)e);
            return null;
        }
        return buf.toString();
    }

    public int length() {
        return this.mFileContents == null ? 0 : this.mFileContents.length();
    }
}

