/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.security;

import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.event.RandomGenerationEvent;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.security.PKISecureRandom;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.HashMap;

public class PKISecureRandomSpi
extends SecureRandomSpi {
    private static final long serialVersionUID = 1L;
    CMSEngine engine;
    SecureRandom random;

    public PKISecureRandomSpi(CMSEngine engine, SecureRandom random) {
        this.engine = engine;
        this.random = random;
    }

    @Override
    public byte[] engineGenerateSeed(int numBytes) {
        return this.random.generateSeed(numBytes);
    }

    @Override
    public void engineSetSeed(byte[] seed) {
        this.random.setSeed(seed);
    }

    @Override
    public void engineNextBytes(byte[] bytes) {
        Auditor auditor = this.engine.getAuditor();
        String caller = null;
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            String className = e.getClassName();
            if (PKISecureRandomSpi.class.getName().equals(className) || PKISecureRandom.class.getName().equals(className) || !className.startsWith("com.netscape.") && !className.startsWith("netscape.") && !className.startsWith("org.dogtagpki.")) continue;
            String methodName = e.getMethodName();
            String fileName = e.getFileName();
            int lineNumber = e.getLineNumber();
            caller = className + "." + methodName + "(" + fileName + ":" + lineNumber + ")";
            break;
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Caller", caller);
        info.put("Size", bytes == null ? null : Integer.toString(bytes.length));
        try {
            this.random.nextBytes(bytes);
            auditor.log(RandomGenerationEvent.createSuccessEvent(this.getSubjectID(), info));
        }
        catch (RuntimeException e) {
            auditor.log(RandomGenerationEvent.createFailureEvent(this.getSubjectID(), info, e.getMessage()));
            throw e;
        }
    }

    protected String getSubjectID() {
        SessionContext context = SessionContext.getExistingContext();
        if (context == null) {
            return "$Unidentified$";
        }
        String subjectID = (String)context.get((Object)"userid");
        if (subjectID == null) {
            return "$NonRoleUser$";
        }
        return subjectID.trim();
    }
}

