/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import netscape.ldap.LDAPSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemDBUpgradeCLI
extends SubsystemCLI {
    public static Logger logger = LoggerFactory.getLogger(SubsystemDBUpgradeCLI.class);

    public SubsystemDBUpgradeCLI(CLI parent) {
        this("upgrade", "Upgrade " + parent.parent.name.toUpperCase() + " database", parent);
    }

    public SubsystemDBUpgradeCLI(String name, String description, CLI parent) {
        super(name, description, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        this.initializeTomcatJSS();
        String subsystem = this.parent.getParent().getName();
        EngineConfig cs = this.getEngineConfig(subsystem);
        cs.load();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        LDAPConnectionConfig connConfig = ldapConfig.getConnectionConfig();
        LdapConnInfo connInfo = new LdapConnInfo(connConfig);
        LdapAuthInfo authInfo = this.getAuthInfo(passwordStore, connInfo, ldapConfig);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PKISocketFactory socketFactory = new PKISocketFactory();
        socketFactory.setSecure(connInfo.getSecure());
        if (authInfo.getAuthType() == 2) {
            String nickname = authInfo.getClientCertNickname();
            logger.info("Authenticating with " + nickname + " certificate");
            socketFactory.setClientCertNickname(nickname);
        } else if (authInfo.getAuthType() == 1) {
            String bindDN = authInfo.getBindDN();
            logger.info("Authenticating as " + bindDN);
        } else {
            logger.info("No authentication");
        }
        socketFactory.init(socketConfig);
        LdapBoundConnection conn = new LdapBoundConnection((LDAPSocketFactory)socketFactory, connInfo, authInfo);
        try {
            this.upgrade(ldapConfig, conn);
        }
        finally {
            conn.disconnect();
        }
        System.out.println(this.parent.parent.name.toUpperCase() + " database upgraded");
    }

    public void upgrade(LDAPConfig ldapConfig, LdapBoundConnection conn) throws Exception {
    }
}

