/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.PKIException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class PKIExceptionMapper
implements ExceptionMapper<PKIException> {
    public static Logger logger = LoggerFactory.getLogger(PKIExceptionMapper.class);
    @Context
    private HttpHeaders headers;

    public Response toResponse(PKIException exception) {
        String entity;
        MediaType contentType;
        block6: {
            logger.info("PKIExceptionMapper: Returning " + ((Object)((Object)exception)).getClass().getSimpleName());
            contentType = MediaType.APPLICATION_XML_TYPE;
            for (MediaType acceptType : this.headers.getAcceptableMediaTypes()) {
                if (acceptType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                    contentType = MediaType.APPLICATION_XML_TYPE;
                    break;
                }
                if (!acceptType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
                contentType = MediaType.APPLICATION_JSON_TYPE;
                break;
            }
            try {
                if (MediaType.APPLICATION_XML_TYPE.isCompatible(contentType)) {
                    entity = exception.getData().toXML();
                    logger.info("PKIExceptionMapper: XML exception:\n" + entity);
                    break block6;
                }
                if (MediaType.APPLICATION_JSON_TYPE.isCompatible(contentType)) {
                    entity = exception.getData();
                    break block6;
                }
                logger.error("PKIExceptionMapper: Unsupported exception format: " + contentType);
                throw new Exception("Unsupported exception format: " + contentType);
            }
            catch (Exception e) {
                logger.error("PKIExceptionMapper: Unable to map exception: " + e.getMessage(), (Throwable)e);
                throw new RuntimeException("Unable to map exception: " + e.getMessage(), e);
            }
        }
        return Response.status((int)exception.getCode()).entity((Object)entity).type(contentType).build();
    }
}

