/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.util.Date;
import org.dogtagpki.acme.ACMEIdentifier;
import org.dogtagpki.acme.server.ACMEPolicyConfig;

public class ACMEPolicy {
    private ACMEPolicyConfig config;

    public ACMEPolicy(ACMEPolicyConfig config) {
        this.config = config;
    }

    public void validateIdentifier(ACMEIdentifier identifier) throws Exception {
        if (!"dns".equals(identifier.getType())) {
            throw new Exception("Unsupported record type: " + identifier.getType());
        }
        this.validateWildcard(identifier.getValue());
    }

    public void validateWildcard(String record) throws Exception {
        if (!record.contains("*")) {
            return;
        }
        if (!record.startsWith("*.")) {
            String msg = "ACME Order Identifier `" + record + "` contains a ";
            msg = msg + "forbidden internal wildcard. It must contain only a ";
            msg = msg + "starting wildcard (\"*.\")";
            throw new Exception(msg);
        }
        int wildcardLength = "*.".length();
        if (record.substring(wildcardLength).contains("*")) {
            String msg = "ACME Order Identifier `" + record + "` contains ";
            msg = msg + "multiple wildcards. It must contain only a starting ";
            msg = msg + "wildcard (\"*.\")";
            throw new Exception(msg);
        }
        if (!this.config.getEnableWildcards()) {
            String msg = "ACME Order Identifier `" + record + "` disallowed ";
            msg = msg + "by ACME Policy because it contains a wildcard.";
            throw new Exception(msg);
        }
    }

    public Date getNonceExpirationTime(Date currentTime) {
        return this.config.getRetention().getNonces().getExpirationTime(currentTime);
    }

    public Date getPendingAuthorizationExpirationTime(Date currentTime) {
        return this.config.getRetention().getPendingAuthorizations().getExpirationTime(currentTime);
    }

    public Date getInvalidAuthorizationExpirationTime(Date currentTime) {
        return this.config.getRetention().getInvalidAuthorizations().getExpirationTime(currentTime);
    }

    public Date getValidAuthorizationExpirationTime(Date currentTime) {
        return this.config.getRetention().getValidAuthorizations().getExpirationTime(currentTime);
    }

    public Date getPendingOrderExpirationTime(Date currentTime) {
        return this.config.getRetention().getPendingOrders().getExpirationTime(currentTime);
    }

    public Date getInvalidOrderExpirationTime(Date currentTime) {
        return this.config.getRetention().getInvalidOrders().getExpirationTime(currentTime);
    }

    public Date getReadyOrderExpirationTime(Date currentTime) {
        return this.config.getRetention().getReadyOrders().getExpirationTime(currentTime);
    }

    public Date getProcessingOrderExpirationTime(Date currentTime) {
        return this.config.getRetention().getProcessingOrders().getExpirationTime(currentTime);
    }

    public Date getValidOrderExpirationTime(Date currentTime) {
        return this.config.getRetention().getValidOrders().getExpirationTime(currentTime);
    }

    public Date getCertificateExpirationTime(Date currentTime) {
        return this.config.getRetention().getCertificates().getExpirationTime(currentTime);
    }
}

