/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.cms;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteRequestHandler {
    public static Logger logger = LoggerFactory.getLogger(RemoteRequestHandler.class);
    private static final String RESPONSE_SEPARATOR = "\\&";
    private static final String NAME_VALUE_EQUAL = "=";
    protected String connid;

    protected Hashtable<String, Object> parseResponse(String content) throws EBaseException {
        logger.debug("RemoteRequestHandler: parseResponse(): begins:");
        if (content == null) {
            throw new EBaseException("RemoteRequestHandler: parserResponse(): no response content.");
        }
        Hashtable<String, Object> vars = new Hashtable<String, Object>();
        String[] elements = content.split(RESPONSE_SEPARATOR);
        logger.debug("RemoteRequestHandler: parseResponse(): # of elements:" + elements.length);
        for (String nvs : elements) {
            String[] nv = nvs.split(NAME_VALUE_EQUAL);
            if (nv.length == 2) {
                vars.put(nv[0], nv[1]);
                continue;
            }
            logger.debug("RemoteRequestHandler: parseResponse(): content contains element not conforming to <name>=<value>.");
        }
        return vars;
    }

    protected XMLObject getXMLparser(String text) {
        logger.debug("RemoteRequestHandler: getXMLparser(): begins");
        if (text == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(text.getBytes());
            return new XMLObject((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("RemoteRequestHandler: getXMLparser(): " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected String getConnid() {
        return this.connid;
    }
}

