/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.tps.profile.ProfileCollection;
import com.netscape.certsrv.tps.profile.ProfileData;
import com.netscape.certsrv.tps.profile.ProfileResource;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.User;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.config.ProfileDatabase;
import org.dogtagpki.server.tps.config.ProfileRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSProfileService
extends SubsystemService
implements ProfileResource {
    public static Logger logger = LoggerFactory.getLogger(TPSProfileService.class);
    public static Pattern PROFILE_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$");
    public static Pattern PROPERTY_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\.]+$");

    public ProfileData createProfileData(ProfileRecord profileRecord) throws UnsupportedEncodingException {
        String profileID = profileRecord.getID();
        ProfileData profileData = new ProfileData();
        profileData.setID(profileID);
        profileData.setProfileID(profileID);
        profileData.setStatus(profileRecord.getStatus());
        profileData.setProperties(profileRecord.getProperties());
        profileID = URLEncoder.encode(profileID, "UTF-8");
        return profileData;
    }

    public ProfileRecord createProfileRecord(ProfileData profileData) {
        ProfileRecord profileRecord = new ProfileRecord();
        profileRecord.setID(profileData.getID());
        profileRecord.setStatus(profileData.getStatus());
        profileRecord.setProperties(profileData.getProperties());
        return profileRecord;
    }

    public Response findProfiles(String filter, Integer start, Integer size) {
        String method = "TPSProfileService.findProfiles: ";
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException(method + "Filter is too short.");
        }
        logger.info(method + "Searching for profiles with filter " + filter);
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        TPSEngine engine = TPSEngine.getInstance();
        try {
            int i;
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileDatabase database = subsystem.getProfileDatabase();
            ArrayList<ProfileRecord> profiles = new ArrayList<ProfileRecord>();
            if (authorizedProfiles != null) {
                Collection<ProfileRecord> filteredProfiles = database.findRecords(filter);
                if (authorizedProfiles.contains("All Profiles")) {
                    logger.debug(method + "User allowed to access all profiles");
                    profiles.addAll(filteredProfiles);
                } else {
                    for (ProfileRecord profile : filteredProfiles) {
                        if (!authorizedProfiles.contains(profile.getID())) continue;
                        logger.debug(method + "User allowed to access profile " + profile.getID());
                        profiles.add(profile);
                    }
                }
            }
            Iterator profileIterator = profiles.iterator();
            ProfileCollection response = new ProfileCollection();
            for (i = 0; i < start && profileIterator.hasNext(); ++i) {
                profileIterator.next();
            }
            while (i < start + size && profileIterator.hasNext()) {
                response.addEntry((Object)this.createProfileData((ProfileRecord)((Object)profileIterator.next())));
                ++i;
            }
            while (profileIterator.hasNext()) {
                profileIterator.next();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (PKIException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response getProfile(String profileID) {
        String method = "ProfileService.getProfile: ";
        Object msg = "";
        logger.info(method + "Retrieving profile " + profileID);
        if (profileID == null) {
            throw new BadRequestException(method + "Missing profile ID");
        }
        TPSEngine engine = TPSEngine.getInstance();
        try {
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null || authorizedProfiles != null && !authorizedProfiles.contains("All Profiles") && !authorizedProfiles.contains(profileID)) {
                msg = "profile record restricted for profileID:" + profileID;
                logger.debug(method + (String)msg);
                throw new PKIException((String)msg);
            }
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileDatabase database = subsystem.getProfileDatabase();
            ProfileRecord profileRecord = database.getRecord(profileID);
            return this.createOKResponse(this.createProfileData(profileRecord));
        }
        catch (PKIException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response addProfile(ProfileData profileData) {
        String method = "TPSProfileService.addProfile: ";
        if (profileData == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Missing profile data");
            throw new BadRequestException(method + "Missing profile data");
        }
        String id = profileData.getID();
        if (id == null) {
            id = profileData.getProfileID();
        }
        logger.info(method + "Adding profile " + id);
        if (!PROFILE_ID_PATTERN.matcher(id).matches()) {
            throw new BadRequestException("Invalid profile ID: " + id);
        }
        Map properties = profileData.getProperties();
        for (String name : properties.keySet()) {
            if (PROPERTY_NAME_PATTERN.matcher(name).matches()) continue;
            throw new BadRequestException(method + "Invalid profile property: " + name);
        }
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileDatabase database = subsystem.getProfileDatabase();
            String status = profileData.getStatus();
            Principal principal = this.servletRequest.getUserPrincipal();
            boolean statusChanged = false;
            if (StringUtils.isEmpty((CharSequence)status) || database.requiresApproval() && !database.canApprove(principal)) {
                status = "Disabled";
                profileData.setStatus(status);
                statusChanged = true;
            }
            database.addRecord(id, this.createProfileRecord(profileData));
            profileData = this.createProfileData(database.getRecord(id));
            if (statusChanged) {
                properties.put("Status", status);
            }
            this.auditTPSProfileChange("Success", method, id, properties, null);
            String profileID = URLEncoder.encode(profileData.getID(), "UTF-8");
            URI uri = this.uriInfo.getBaseUriBuilder().path(ProfileResource.class).path("{profileID}").build(new Object[]{profileID});
            return this.createCreatedResponse(profileData, uri);
        }
        catch (PKIException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            this.auditTPSProfileChange("Failure", method, id, null, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            this.auditTPSProfileChange("Failure", method, id, null, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response updateProfile(String profileID, ProfileData profileData) {
        String method = "TPSProfileService.updateProfile: ";
        Object msg = "";
        if (profileID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Missing profile ID");
            throw new BadRequestException("Missing profile ID");
        }
        logger.info(method + "Updating profile " + profileID);
        if (profileData == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Missing profile data");
            throw new BadRequestException("Missing profile data");
        }
        Map properties = profileData.getProperties();
        for (String name : properties.keySet()) {
            if (PROPERTY_NAME_PATTERN.matcher(name).matches()) continue;
            throw new BadRequestException("Invalid profile property: " + name);
        }
        TPSEngine engine = TPSEngine.getInstance();
        try {
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null || authorizedProfiles != null && !authorizedProfiles.contains("All Profiles") && !authorizedProfiles.contains(profileID)) {
                msg = "profile record restricted for profileID:" + profileID;
                logger.debug(method + (String)msg);
                throw new PKIException((String)msg);
            }
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileDatabase database = subsystem.getProfileDatabase();
            ProfileRecord record = database.getRecord(profileID);
            if (!"Disabled".equals(record.getStatus())) {
                ForbiddenException e = new ForbiddenException("Unable to update profile " + profileID);
                this.auditTPSProfileChange("Failure", method, profileID, profileData.getProperties(), e.toString());
                throw e;
            }
            String status = profileData.getStatus();
            boolean statusChanged = false;
            if (status != null && !"Disabled".equals(status)) {
                if (!"Enabled".equals(status)) {
                    ForbiddenException e = new ForbiddenException(method + "Invalid profile status: " + status);
                    this.auditTPSProfileChange("Failure", method, profileID, profileData.getProperties(), e.toString());
                    throw e;
                }
                Principal principal = this.servletRequest.getUserPrincipal();
                if (database.requiresApproval() && !database.canApprove(principal)) {
                    status = "Pending_Approval";
                }
                record.setStatus(status);
                statusChanged = true;
            }
            if (properties != null) {
                record.setProperties(properties);
                if (statusChanged) {
                    properties.put("Status", status);
                }
            }
            database.updateRecord(profileID, record);
            profileData = this.createProfileData(database.getRecord(profileID));
            this.auditTPSProfileChange("Success", method, profileData.getID(), properties, null);
            return this.createOKResponse(profileData);
        }
        catch (PKIException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            this.auditTPSProfileChange("Failure", method, profileID, profileData.getProperties(), e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            this.auditTPSProfileChange("Failure", method, profileID, profileData.getProperties(), e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response changeStatus(String profileID, String action) {
        String method = "TPSProfileService.changeStatus: ";
        Object msg = "";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (profileID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Missin profile ID");
            throw new BadRequestException("Missing profile ID");
        }
        auditModParams.put("profileID", profileID);
        if (action == null) {
            this.auditConfigTokenGeneral("Failure", method, auditModParams, "Missing action");
            throw new BadRequestException("Missing action");
        }
        auditModParams.put("Action", action);
        logger.info(method + "Changing profile " + profileID + " status: " + action);
        TPSEngine engine = TPSEngine.getInstance();
        try {
            String status;
            ProfileRecord record;
            ProfileDatabase database;
            block21: {
                boolean canApprove;
                block22: {
                    block23: {
                        List<String> authorizedProfiles = this.getAuthorizedProfiles();
                        if (authorizedProfiles == null || authorizedProfiles != null && !authorizedProfiles.contains("All Profiles") && !authorizedProfiles.contains(profileID)) {
                            msg = "profile record restricted for profileID:" + profileID;
                            logger.debug(method + (String)msg);
                            throw new PKIException((String)msg);
                        }
                        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                        database = subsystem.getProfileDatabase();
                        record = database.getRecord(profileID);
                        status = record.getStatus();
                        Principal principal = this.servletRequest.getUserPrincipal();
                        canApprove = database.canApprove(principal);
                        if (!"Disabled".equals(status)) break block22;
                        if (!database.requiresApproval()) break block23;
                        if ("submit".equals(action) && !canApprove) {
                            status = "Pending_Approval";
                            break block21;
                        } else if ("enable".equals(action) && canApprove) {
                            status = "Enabled";
                            break block21;
                        } else {
                            BadRequestException e = new BadRequestException(method + "Invalid action: " + action);
                            this.auditTPSProfileChange("Failure", method, profileID, auditModParams, e.toString());
                            throw e;
                        }
                    }
                    if (!"enable".equals(action)) {
                        BadRequestException e = new BadRequestException(method + "Invalid action: " + action);
                        this.auditTPSProfileChange("Failure", method, profileID, auditModParams, e.toString());
                        throw e;
                    }
                    status = "Enabled";
                    break block21;
                }
                if ("Enabled".equals(status)) {
                    if (!"disable".equals(action)) {
                        BadRequestException e = new BadRequestException(method + "Invalid action: " + action);
                        this.auditTPSProfileChange("Failure", method, profileID, auditModParams, e.toString());
                        throw e;
                    }
                    status = "Disabled";
                } else {
                    if (!"Pending_Approval".equals(status)) {
                        PKIException e = new PKIException(method + "Invalid profile status: " + status);
                        this.auditTPSProfileChange("Failure", method, profileID, auditModParams, e.toString());
                        throw e;
                    }
                    if ("approve".equals(action) && canApprove) {
                        status = "Enabled";
                    } else if ("reject".equals(action) && canApprove) {
                        status = "Disabled";
                    } else if ("cancel".equals(action) && !canApprove) {
                        status = "Disabled";
                    } else {
                        BadRequestException e = new BadRequestException(method + "Invalid action: " + action);
                        this.auditTPSProfileChange("Failure", method, profileID, auditModParams, e.toString());
                        throw e;
                    }
                }
            }
            record.setStatus(status);
            database.updateRecord(profileID, record);
            ProfileData profileData = this.createProfileData(database.getRecord(profileID));
            auditModParams.put("Status", status);
            this.auditTPSProfileChange("Success", method, profileID, auditModParams, null);
            return this.createOKResponse(profileData);
        }
        catch (PKIException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            this.auditConfigTokenGeneral("Failure", method, auditModParams, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            this.auditConfigTokenGeneral("Failure", method, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response removeProfile(String profileID) {
        String method = "TPSProfileService.removeProfile: ";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (profileID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Profile ID is null.");
            throw new BadRequestException("Profile ID is null.");
        }
        auditModParams.put("profileID", profileID);
        logger.info(method + "Removing profile " + profileID);
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileDatabase database = subsystem.getProfileDatabase();
            ProfileRecord record = database.getRecord(profileID);
            String status = record.getStatus();
            if (!"Disabled".equals(status)) {
                ForbiddenException e = new ForbiddenException("Profile " + profileID + " is not disabled");
                this.auditTPSProfileChange("Failure", method, profileID, auditModParams, e.toString());
                throw e;
            }
            database.removeRecord(profileID);
            this.auditTPSProfileChange("Success", method, profileID, null, null);
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            this.auditTPSProfileChange("Failure", method, profileID, auditModParams, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            this.auditTPSProfileChange("Failure", method, profileID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    List<String> getAuthorizedProfiles() throws Exception {
        String method = "ProfileService.getAuthorizedProfiles: ";
        PKIPrincipal pkiPrincipal = (PKIPrincipal)this.servletRequest.getUserPrincipal();
        if (pkiPrincipal == null) {
            logger.debug(method + "servletRequest.getUserPrincipal() returned null");
            return null;
        }
        User user = pkiPrincipal.getUser();
        return user.getTpsProfiles();
    }

    public void auditTPSProfileChange(String status, String service, String profileID, Map<String, String> params, String info) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_TOKEN_PROFILE_6", (Object[])new Object[]{this.servletRequest.getUserPrincipal().getName(), status, service, profileID, auditor.getParamString(params), info});
        auditor.log(msg);
    }
}

