/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.MetricFinder;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.utils.KeyValueFormat;

public class DefaultFileLinesContext
implements FileLinesContext {
    private final InputFile inputFile;
    private final MetricFinder metricFinder;
    private final Map<String, Map<Integer, Object>> map = new HashMap<String, Map<Integer, Object>>();
    private final SensorStorage sensorStorage;

    public DefaultFileLinesContext(SensorStorage sensorStorage, InputFile inputFile, MetricFinder metricFinder) {
        this.sensorStorage = sensorStorage;
        this.inputFile = inputFile;
        this.metricFinder = metricFinder;
    }

    @Override
    public void setIntValue(String metricKey, int line, int value) {
        Preconditions.checkNotNull(metricKey);
        this.checkLineRange(line);
        this.setValue(metricKey, line, value);
    }

    private void checkLineRange(int line) {
        Preconditions.checkArgument(line > 0, "Line number should be positive for file %s.", this.inputFile);
        Preconditions.checkArgument(line <= this.inputFile.lines(), "Line %s is out of range for file %s. File has %s lines.", line, this.inputFile, this.inputFile.lines());
    }

    @Override
    public void setStringValue(String metricKey, int line, String value) {
        Preconditions.checkNotNull(metricKey);
        this.checkLineRange(line);
        Preconditions.checkNotNull(value);
        this.setValue(metricKey, line, value);
    }

    private void setValue(String metricKey, int line, Object value) {
        this.map.computeIfAbsent(metricKey, k -> new HashMap()).put(line, value);
    }

    @Override
    public void save() {
        for (Map.Entry<String, Map<Integer, Object>> entry : this.map.entrySet()) {
            String metricKey = entry.getKey();
            Map<Integer, Object> lines = entry.getValue();
            if (!DefaultFileLinesContext.shouldSave(lines)) continue;
            String data = KeyValueFormat.format(DefaultFileLinesContext.optimizeStorage(metricKey, lines));
            ((DefaultStorable)((Object)((DefaultMeasure)((DefaultMeasure)new DefaultMeasure(this.sensorStorage).on(this.inputFile)).forMetric(this.metricFinder.findByKey(metricKey))).withValue((Serializable)((Object)data)))).save();
            entry.setValue(ImmutableMap.copyOf(lines));
        }
    }

    private static Map<Integer, Object> optimizeStorage(String metricKey, Map<Integer, Object> lines) {
        if ("ncloc_data".equals(metricKey) || "executable_lines_data".equals(metricKey)) {
            return lines.entrySet().stream().filter(entry -> !entry.getValue().equals(0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return lines;
    }

    private static boolean shouldSave(Map<Integer, Object> lines) {
        return !(lines instanceof ImmutableMap);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("map", this.map).toString();
    }
}

