/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.Encryption;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.internal.MultivalueProperty;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@Immutable
public abstract class DefaultConfiguration
implements Configuration {
    private static final Logger LOG = Loggers.get(DefaultConfiguration.class);
    private final PropertyDefinitions definitions;
    private final Encryption encryption;
    private final Map<String, String> properties;
    private final Map<String, String> originalProperties;

    public DefaultConfiguration(PropertyDefinitions propertyDefinitions, Encryption encryption, Map<String, String> props) {
        this.definitions = Objects.requireNonNull(propertyDefinitions);
        this.encryption = encryption;
        this.properties = DefaultConfiguration.unmodifiableMapWithTrimmedValues(this.definitions, props);
        this.originalProperties = Collections.unmodifiableMap(props);
    }

    protected static Map<String, String> unmodifiableMapWithTrimmedValues(PropertyDefinitions definitions, Map<String, String> props) {
        HashMap map = new HashMap(props.size());
        props.forEach((k, v) -> {
            String validKey = definitions.validKey((String)k);
            map.put(validKey, StringUtils.trim(v));
        });
        return Collections.unmodifiableMap(map);
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public PropertyDefinitions getDefinitions() {
        return this.definitions;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getOriginalProperties() {
        return this.originalProperties;
    }

    @Override
    public boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public Optional<String> get(String key) {
        String effectiveKey = this.definitions.validKey(key);
        PropertyDefinition def = this.definitions.get(effectiveKey);
        if (def != null && (def.multiValues() || !def.fields().isEmpty())) {
            LOG.warn("Access to the multi-values/property set property '{}' should be made using 'getStringArray' method. The SonarQube plugin using this property should be updated.", (Object)key);
        }
        return this.getInternal(effectiveKey);
    }

    @Override
    public String[] getStringArray(String key) {
        Optional<String> value;
        String effectiveKey = this.definitions.validKey(key);
        PropertyDefinition def = this.definitions.get(effectiveKey);
        if (def != null && !def.multiValues() && def.fields().isEmpty()) {
            LOG.warn("Property '{}' is not declared as multi-values/property set but was read using 'getStringArray' method. The SonarQube plugin declaring this property should be updated.", (Object)key);
        }
        if ((value = this.getInternal(effectiveKey)).isPresent()) {
            return MultivalueProperty.parseAsCsv(effectiveKey, value.get());
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private Optional<String> getInternal(String key) {
        Optional<String> value = Optional.ofNullable(this.properties.get(key));
        if (!value.isPresent()) {
            return Optional.ofNullable(this.definitions.getDefaultValue(key));
        }
        if (this.encryption.isEncrypted(value.get())) {
            try {
                return Optional.of(this.encryption.decrypt(value.get()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to decrypt the property " + key + ". Please check your secret key.", e);
            }
        }
        return value;
    }
}

