/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.issue.DefaultFilterableIssue;
import org.sonar.scanner.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.IssuePattern;

@ThreadSafe
public class EnforceIssuesFilter
implements IssueFilter {
    private static final Logger LOG = Loggers.get(EnforceIssuesFilter.class);
    private final List<IssuePattern> multicriteriaPatterns;
    private final AnalysisWarnings analysisWarnings;
    private boolean warnDeprecatedIssuePatternAlreadyLogged;

    public EnforceIssuesFilter(IssueInclusionPatternInitializer patternInitializer, AnalysisWarnings analysisWarnings) {
        this.multicriteriaPatterns = Collections.unmodifiableList(new ArrayList<IssuePattern>(patternInitializer.getMulticriteriaPatterns()));
        this.analysisWarnings = analysisWarnings;
    }

    @Override
    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        boolean atLeastOneRuleMatched = false;
        boolean atLeastOnePatternFullyMatched = false;
        IssuePattern matchingPattern = null;
        for (IssuePattern pattern : this.multicriteriaPatterns) {
            if (!pattern.matchRule(issue.ruleKey())) continue;
            atLeastOneRuleMatched = true;
            InputComponent component = ((DefaultFilterableIssue)issue).getComponent();
            if (!component.isFile()) continue;
            DefaultInputFile file = (DefaultInputFile)component;
            if (pattern.matchFile(file.getProjectRelativePath())) {
                atLeastOnePatternFullyMatched = true;
                matchingPattern = pattern;
                continue;
            }
            if (!pattern.matchFile(file.getModuleRelativePath())) continue;
            this.warnOnceDeprecatedIssuePattern("Specifying module-relative paths at project level in property 'sonar.issue.enforce.multicriteria' is deprecated. To continue matching files like '" + file.getProjectRelativePath() + "', update this property so that patterns refer to project-relative paths.");
            atLeastOnePatternFullyMatched = true;
            matchingPattern = pattern;
        }
        if (atLeastOneRuleMatched) {
            if (atLeastOnePatternFullyMatched) {
                LOG.debug("Issue {} enforced by pattern {}", (Object)issue, (Object)matchingPattern);
            }
            return atLeastOnePatternFullyMatched;
        }
        return chain.accept(issue);
    }

    private void warnOnceDeprecatedIssuePattern(String msg) {
        if (!this.warnDeprecatedIssuePatternAlreadyLogged) {
            LOG.warn(msg);
            this.analysisWarnings.addUnique(msg);
            this.warnDeprecatedIssuePatternAlreadyLogged = true;
        }
    }
}

