/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.platform;

import java.io.File;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.DateUtils;
import org.sonar.scanner.bootstrap.ScannerWsClient;

public class DefaultServer
extends Server {
    private final Configuration settings;
    private final ScannerWsClient client;
    private final SonarRuntime runtime;

    public DefaultServer(Configuration settings, ScannerWsClient client, SonarRuntime runtime) {
        this.settings = settings;
        this.client = client;
        this.runtime = runtime;
    }

    @Override
    public String getId() {
        return this.settings.get("sonar.core.id").orElseThrow(() -> new IllegalStateException("Mandatory"));
    }

    @Override
    public String getVersion() {
        return this.runtime.getApiVersion().toString();
    }

    @Override
    public Date getStartedAt() {
        String dateString = this.settings.get("sonar.core.startTime").orElseThrow(() -> new IllegalStateException("Mandatory"));
        return DateUtils.parseDateTime(dateString);
    }

    @Override
    public File getRootDir() {
        return null;
    }

    @Override
    public String getContextPath() {
        return null;
    }

    @Override
    public String getPublicRootUrl() {
        String baseUrl = StringUtils.trimToEmpty(this.settings.get("sonar.core.serverBaseURL").orElse(""));
        if (baseUrl.isEmpty()) {
            baseUrl = this.client.baseUrl();
        }
        return StringUtils.removeEnd(baseUrl, "/");
    }

    @Override
    public boolean isDev() {
        return false;
    }

    @Override
    public boolean isSecured() {
        return false;
    }

    @Override
    public String getURL() {
        return StringUtils.removeEnd(this.client.baseUrl(), "/");
    }

    @Override
    public String getPermanentServerId() {
        return this.getId();
    }
}

