/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.flex.FlexCommentAnalyser;
import org.sonar.flex.FlexVisitor;

public class FileLinesVisitor
extends FlexVisitor {
    private Set<Integer> linesOfCode;
    private Set<Integer> linesOfComments;
    private Set<Integer> noSonarLines;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.linesOfCode = new HashSet<Integer>();
        this.linesOfComments = new HashSet<Integer>();
        this.noSonarLines = new HashSet<Integer>();
    }

    @Override
    public void visitToken(Token token) {
        if (!token.getType().equals(GenericTokenType.EOF)) {
            this.linesOfCode.add(token.getLine());
        }
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            this.visitComment(trivia);
        }
    }

    private void visitComment(Trivia trivia) {
        String[] commentLines = FlexCommentAnalyser.getContents(trivia.getToken().getOriginalValue()).split("(\r)?\n|\r", -1);
        int line = trivia.getToken().getLine();
        for (String commentLine : commentLines) {
            if (commentLine.contains("NOSONAR")) {
                this.linesOfComments.remove(line);
                this.noSonarLines.add(line);
            } else if (!FlexCommentAnalyser.isBlank(commentLine) && !this.noSonarLines.contains(line)) {
                this.linesOfComments.add(line);
            }
            ++line;
        }
    }

    public Set<Integer> linesOfCode() {
        return this.linesOfCode;
    }

    public Set<Integer> linesOfComments() {
        return this.linesOfComments;
    }

    public Set<Integer> noSonarLines() {
        return this.noSonarLines;
    }
}

