/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import javax.annotation.Nullable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public final class ContextHelper {
    private static final Logger LOG = Loggers.get(ContextHelper.class);

    private ContextHelper() {
    }

    public static void close(@Nullable Context context, boolean swallowIOException) throws NamingException {
        if (context == null) {
            return;
        }
        try {
            context.close();
        }
        catch (NamingException e) {
            if (swallowIOException) {
                LOG.warn("NamingException thrown while closing context.", (Throwable)e);
            }
            throw e;
        }
    }

    public static void closeQuietly(@Nullable Context context) {
        try {
            ContextHelper.close(context, true);
        }
        catch (NamingException e) {
            LOG.error("Unexpected NamingException", (Throwable)e);
        }
    }
}

