/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.BinaryExpressionLike;

@Rule(key="S3981")
public class CollectionSizeCheck
extends Check {
    private static final String MESSAGE = "The length of a collection is always \">=0\", so update this test to either \"==0\" or \">0\".";

    public CollectionSizeCheck() {
        super(UastNode.Kind.GREATER_OR_EQUAL, UastNode.Kind.LESS_THAN);
    }

    @Override
    public void visitNode(UastNode node) {
        BinaryExpressionLike binaryExpression = BinaryExpressionLike.from(node);
        if (binaryExpression != null) {
            UastNode rhs = binaryExpression.rightOperand();
            UastNode lhs = binaryExpression.leftOperand();
            if (CollectionSizeCheck.isLenCall(lhs) && CollectionSizeCheck.isZero(rhs)) {
                this.reportIssue(node, MESSAGE);
            }
        }
    }

    private static boolean isZero(UastNode node) {
        return node.is(UastNode.Kind.INT_LITERAL) && node.token != null && node.token.value.equals("0");
    }

    private static boolean isLenCall(UastNode node) {
        if (node.is(UastNode.Kind.CALL)) {
            UastNode callee = node.getChildren(UastNode.Kind.EXPRESSION).get(0);
            return callee.is(UastNode.Kind.IDENTIFIER) && callee.token != null && callee.token.value.equals("len");
        }
        return false;
    }
}

