/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.CaseLike;

@Rule(key="S1151")
public class SwitchCaseTooBigCheck
extends Check {
    private static final int DEFAULT_MAXIMUM = 5;
    @RuleProperty(key="max", description="Maximum number of lines", defaultValue="5")
    public int max = 5;

    public SwitchCaseTooBigCheck() {
        super(UastNode.Kind.CASE, UastNode.Kind.DEFAULT_CASE);
    }

    @Override
    public void visitNode(UastNode node) {
        int caseLength;
        UastNode caseBody = CaseLike.from(node).body();
        if (caseBody != null && (caseLength = caseBody.lastToken().line - caseBody.firstToken().line + 1) > this.max) {
            node.getChild(UastNode.Kind.KEYWORD).ifPresent(caseKeyword -> this.reportIssue((UastNode)caseKeyword, "Reduce this switch case number of lines from " + caseLength + " to at most " + this.max + ", for example by extracting code into functions."));
        }
    }
}

