/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.List;
import java.util.ListIterator;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S1763")
public class UnreachableCodeCheck
extends Check {
    public UnreachableCodeCheck() {
        super(UastNode.Kind.BLOCK);
    }

    @Override
    public void visitNode(UastNode node) {
        List<UastNode> statements = node.getChildren(UastNode.Kind.STATEMENT);
        ListIterator<UastNode> stmtIterator = statements.listIterator();
        while (stmtIterator.hasNext()) {
            UastNode afterJump;
            UastNode statement = stmtIterator.next();
            if (!statement.is(UastNode.Kind.UNCONDITIONAL_JUMP) || !stmtIterator.hasNext() || !(afterJump = stmtIterator.next()).isNot(UastNode.Kind.LABEL)) continue;
            this.reportIssue(statement, "Refactor this piece of code to not have any dead code after this " + statement.firstToken().value + ".");
        }
    }
}

