/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.go.plugin.ExternalProcessStreamConsumer;
import org.sonar.uast.UastNode;

class UastGeneratorWrapper {
    private static final Logger LOG = Loggers.get(UastGeneratorWrapper.class);
    private final ProcessBuilder processBuilder;
    private final ExternalProcessStreamConsumer errorConsumer;

    UastGeneratorWrapper(SensorContext sensorContext) throws IOException {
        this(new DefaultCommand(sensorContext.fileSystem().workDir()));
    }

    UastGeneratorWrapper(Command command) {
        this.processBuilder = new ProcessBuilder(command.getCommand());
        this.errorConsumer = new ExternalProcessStreamConsumer();
    }

    UastNode createUast(InputStream source) throws IOException, InterruptedException {
        Process process = this.processBuilder.start();
        this.errorConsumer.consumeStream(process.getErrorStream(), arg_0 -> ((Logger)LOG).debug(arg_0));
        try (OutputStream out = process.getOutputStream();){
            UastNode uastNode;
            block14: {
                InputStream in = process.getInputStream();
                try {
                    UastGeneratorWrapper.copy(source, process.getOutputStream());
                    out.close();
                    UastNode uastNode2 = UastNode.from(new InputStreamReader(in, StandardCharsets.UTF_8));
                    boolean exited = process.waitFor(5L, TimeUnit.SECONDS);
                    if (exited && process.exitValue() != 0) {
                        throw new IllegalStateException("Parser returned non-zero exit value: " + process.exitValue());
                    }
                    if (process.isAlive()) {
                        process.destroyForcibly();
                        throw new IllegalStateException("Took too long to parse. External process killed forcibly");
                    }
                    uastNode = uastNode2;
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return uastNode;
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
    }

    static class DefaultCommand
    implements Command {
        private final String command;

        DefaultCommand(File workDir) throws IOException {
            this.command = this.extract(workDir);
        }

        @Override
        public List<String> getCommand() {
            return Arrays.asList(this.command, "-");
        }

        private String extract(File workDir) throws IOException {
            String executable = DefaultCommand.getExecutableForCurrentOS();
            File dest = new File(workDir, executable);
            InputStream streamOfExecutable = this.getClass().getClassLoader().getResourceAsStream(executable);
            if (streamOfExecutable == null) {
                throw new IllegalStateException(executable + " binary not found on class path");
            }
            try (FileOutputStream destStream = new FileOutputStream(dest);){
                String string;
                block12: {
                    InputStream in = streamOfExecutable;
                    try {
                        UastGeneratorWrapper.copy(in, destStream);
                        dest.setExecutable(true);
                        string = dest.getAbsolutePath();
                        if (in == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return string;
            }
        }

        private static String getExecutableForCurrentOS() {
            String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            if (os.contains("win")) {
                return "uast-generator-go-windows-amd64.exe";
            }
            if (os.contains("mac")) {
                return "uast-generator-go-darwin-amd64";
            }
            return "uast-generator-go-linux-amd64";
        }
    }

    static interface Command {
        public List<String> getCommand();
    }
}

