/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin.externalreport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.go.plugin.externalreport.AbstractReportSensor;
import org.sonar.go.plugin.externalreport.ExternalIssue;

public class GoVetReportSensor
extends AbstractReportSensor {
    private static final Logger LOG = Loggers.get(GoVetReportSensor.class);
    public static final String PROPERTY_KEY = "sonar.go.govet.reportPaths";
    private static final Pattern GO_VET_LINE_REGEX = Pattern.compile("(?<file>[^:]+):(?<line>\\d+):(?<message>.*)");
    public static final String LINTER_ID = "govet";
    public static final String LINTER_NAME = "go vet";

    @Override
    String linterName() {
        return LINTER_NAME;
    }

    @Override
    String reportsPropertyName() {
        return PROPERTY_KEY;
    }

    @Override
    @Nullable
    ExternalIssue parse(String line) {
        Matcher matcher = GO_VET_LINE_REGEX.matcher(line);
        if (matcher.matches()) {
            String filename = matcher.group("file").trim();
            int lineNumber = Integer.parseInt(matcher.group("line").trim());
            String message = matcher.group("message").trim();
            return new ExternalIssue(LINTER_ID, RuleType.BUG, null, filename, lineNumber, message);
        }
        if (!line.startsWith("exit status")) {
            LOG.debug(this.logPrefix() + "Unexpected line: " + line);
        }
        return null;
    }
}

