/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.DbIdsRepository;
import org.sonar.ce.task.projectanalysis.component.MutableDbIdsRepository;

public final class MapBasedDbIdsRepository<T>
implements MutableDbIdsRepository {
    private final Function<Component, T> componentToKey;
    private final Map<T, Long> componentIdsByRef = new HashMap<T, Long>();

    public MapBasedDbIdsRepository(Function<Component, T> componentToKey) {
        this.componentToKey = componentToKey;
    }

    @Override
    public DbIdsRepository setComponentId(Component component, long componentId) {
        T ref = this.componentToKey.apply(component);
        Long existingComponentId = this.componentIdsByRef.get(ref);
        Preconditions.checkState((existingComponentId == null ? 1 : 0) != 0, (String)"Component id '%s' is already registered in repository for Component '%s', can not set new id '%s'", (Object[])new Object[]{existingComponentId, component.getDbKey(), componentId});
        this.componentIdsByRef.put(ref, componentId);
        return this;
    }

    @Override
    public long getComponentId(Component component) {
        T ref = this.componentToKey.apply(component);
        Long componentId = this.componentIdsByRef.get(ref);
        Preconditions.checkState((componentId != null ? 1 : 0) != 0, (String)"No component id registered in repository for Component '%s'", (Object[])new Object[]{component.getDbKey()});
        return componentId;
    }
}

