/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import java.util.Objects;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitor;

public abstract class PathAwareVisitorAdapter<T>
implements PathAwareVisitor<T> {
    private final CrawlerDepthLimit maxDepth;
    private final ComponentVisitor.Order order;
    private final PathAwareVisitor.StackElementFactory<T> factory;

    public PathAwareVisitorAdapter(CrawlerDepthLimit maxDepth, ComponentVisitor.Order order, PathAwareVisitor.StackElementFactory<T> factory) {
        this.maxDepth = Objects.requireNonNull(maxDepth);
        this.order = Objects.requireNonNull(order);
        this.factory = Objects.requireNonNull(factory, "Factory can not be null");
    }

    @Override
    public CrawlerDepthLimit getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public ComponentVisitor.Order getOrder() {
        return this.order;
    }

    @Override
    public PathAwareVisitor.StackElementFactory<T> getFactory() {
        return this.factory;
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<T> path) {
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<T> path) {
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<T> path) {
    }

    @Override
    public void visitView(Component view, PathAwareVisitor.Path<T> path) {
    }

    @Override
    public void visitSubView(Component subView, PathAwareVisitor.Path<T> path) {
    }

    @Override
    public void visitProjectView(Component projectView, PathAwareVisitor.Path<T> path) {
    }

    @Override
    public void visitAny(Component component, PathAwareVisitor.Path<T> path) {
    }

    public static abstract class SimpleStackElementFactory<T>
    implements PathAwareVisitor.StackElementFactory<T> {
        public abstract T createForAny(Component var1);

        @Override
        public T createForProject(Component project) {
            return this.createForAny(project);
        }

        @Override
        public T createForDirectory(Component directory) {
            return this.createForAny(directory);
        }

        @Override
        public T createForFile(Component file) {
            return this.createForAny(file);
        }

        @Override
        public T createForView(Component view) {
            return this.createForAny(view);
        }

        @Override
        public T createForSubView(Component subView) {
            return this.createForAny(subView);
        }

        @Override
        public T createForProjectView(Component projectView) {
            return this.createForAny(projectView);
        }
    }
}

