/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.api.config.Configuration;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.issue.Rule;
import org.sonar.ce.task.projectanalysis.issue.RuleRepository;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRulesHolder;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.issue.IssueMapper;

public class ComponentIssuesLoader {
    private static final int DEFAULT_CLOSED_ISSUES_MAX_AGE = 30;
    private static final String PROPERTY_CLOSED_ISSUE_MAX_AGE = "sonar.issuetracking.closedissues.maxage";
    private final DbClient dbClient;
    private final RuleRepository ruleRepository;
    private final ActiveRulesHolder activeRulesHolder;
    private final System2 system2;
    private final int closedIssueMaxAge;

    public ComponentIssuesLoader(DbClient dbClient, RuleRepository ruleRepository, ActiveRulesHolder activeRulesHolder, Configuration configuration, System2 system2) {
        this.dbClient = dbClient;
        this.activeRulesHolder = activeRulesHolder;
        this.ruleRepository = ruleRepository;
        this.system2 = system2;
        this.closedIssueMaxAge = configuration.get(PROPERTY_CLOSED_ISSUE_MAX_AGE).map(ComponentIssuesLoader::safelyParseClosedIssueMaxAge).filter(i -> i >= 0).orElse(30);
    }

    private static Integer safelyParseClosedIssueMaxAge(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            Loggers.get(ComponentIssuesLoader.class).warn("Value of property {} should be an integer >= 0: {}", (Object)PROPERTY_CLOSED_ISSUE_MAX_AGE, (Object)str);
            return null;
        }
    }

    public List<DefaultIssue> loadOpenIssues(String componentUuid) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<DefaultIssue> list = this.loadOpenIssues(componentUuid, dbSession);
            return list;
        }
    }

    public List<DefaultIssue> loadOpenIssuesWithChanges(String componentUuid) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<DefaultIssue> result = this.loadOpenIssues(componentUuid, dbSession);
            List<DefaultIssue> list = this.loadChanges(dbSession, result);
            return list;
        }
    }

    public List<DefaultIssue> loadChanges(DbSession dbSession, Collection<DefaultIssue> issues) {
        Map<String, List<IssueChangeDto>> changeDtoByIssueKey = this.dbClient.issueChangeDao().selectByIssueKeys(dbSession, (Collection)issues.stream().map(DefaultIssue::key).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(IssueChangeDto::getIssueKey));
        return issues.stream().peek(i -> ComponentIssuesLoader.setChanges(changeDtoByIssueKey, i)).collect(Collectors.toList());
    }

    public void loadLatestDiffChangesForReopeningOfClosedIssues(Collection<DefaultIssue> issues) {
        if (issues.isEmpty()) {
            return;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.loadLatestDiffChangesForReopeningOfClosedIssues(dbSession, issues);
        }
    }

    private void loadLatestDiffChangesForReopeningOfClosedIssues(DbSession dbSession, Collection<DefaultIssue> issues) {
        final Map issuesByKey = (Map)issues.stream().collect(MoreCollectors.uniqueIndex(DefaultIssue::key));
        this.dbClient.issueChangeDao().scrollDiffChangesOfIssues(dbSession, issuesByKey.keySet(), (ResultHandler)new ResultHandler<IssueChangeDto>(){
            private DefaultIssue currentIssue = null;
            private boolean previousStatusFound = false;
            private boolean previousResolutionFound = false;

            public void handleResult(ResultContext<? extends IssueChangeDto> resultContext) {
                IssueChangeDto issueChangeDto = (IssueChangeDto)resultContext.getResultObject();
                if (this.currentIssue == null || !this.currentIssue.key().equals(issueChangeDto.getIssueKey())) {
                    this.currentIssue = (DefaultIssue)issuesByKey.get(issueChangeDto.getIssueKey());
                    this.previousStatusFound = false;
                    this.previousResolutionFound = false;
                }
                if (this.currentIssue != null) {
                    boolean hasPreviousResolution;
                    FieldDiffs fieldDiffs = issueChangeDto.toFieldDiffs();
                    boolean hasPreviousStatus = fieldDiffs.get("status") != null;
                    boolean bl = hasPreviousResolution = fieldDiffs.get("resolution") != null;
                    if (!this.previousStatusFound && hasPreviousStatus || !this.previousResolutionFound && hasPreviousResolution) {
                        this.currentIssue.addChange(fieldDiffs);
                    }
                    this.previousStatusFound |= hasPreviousStatus;
                    this.previousResolutionFound |= hasPreviousResolution;
                }
            }
        });
    }

    private List<DefaultIssue> loadOpenIssues(String componentUuid, DbSession dbSession) {
        ArrayList result = new ArrayList();
        ((IssueMapper)dbSession.getMapper(IssueMapper.class)).scrollNonClosedByComponentUuid(componentUuid, resultContext -> {
            DefaultIssue issue = ((IssueDto)resultContext.getResultObject()).toDefaultIssue();
            Rule rule = this.ruleRepository.getByKey(issue.ruleKey());
            if (!rule.isExternal() && !this.isActive(issue.ruleKey()) || rule.getStatus() == RuleStatus.REMOVED) {
                issue.setOnDisabledRule(true);
                issue.setBeingClosed(true);
            }
            issue.setSelectedAt(Long.valueOf(System.currentTimeMillis()));
            result.add(issue);
        });
        return ImmutableList.copyOf(result);
    }

    private static void setChanges(Map<String, List<IssueChangeDto>> changeDtoByIssueKey, DefaultIssue i) {
        changeDtoByIssueKey.computeIfAbsent(i.key(), k -> Collections.emptyList()).forEach(c -> ComponentIssuesLoader.addChangeOrComment(i, c));
    }

    private static void addChangeOrComment(DefaultIssue i, IssueChangeDto c) {
        switch (c.getChangeType()) {
            case "diff": {
                i.addChange(c.toFieldDiffs());
                break;
            }
            case "comment": {
                i.addComment(c.toComment());
                break;
            }
            default: {
                throw new IllegalStateException("Unknow change type: " + c.getChangeType());
            }
        }
    }

    private boolean isActive(RuleKey ruleKey) {
        return this.activeRulesHolder.get(ruleKey).isPresent();
    }

    public List<DefaultIssue> loadClosedIssues(String componentUuid) {
        if (this.closedIssueMaxAge == 0) {
            return Collections.emptyList();
        }
        Date date = new Date(this.system2.now());
        long closeDateAfter = date.toInstant().minus(this.closedIssueMaxAge, ChronoUnit.DAYS).truncatedTo(ChronoUnit.DAYS).toEpochMilli();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<DefaultIssue> list = ComponentIssuesLoader.loadClosedIssues(dbSession, componentUuid, closeDateAfter);
            return list;
        }
    }

    private static List<DefaultIssue> loadClosedIssues(DbSession dbSession, String componentUuid, long closeDateAfter) {
        ClosedIssuesResultHandler handler = new ClosedIssuesResultHandler();
        ((IssueMapper)dbSession.getMapper(IssueMapper.class)).scrollClosedByComponentUuid(componentUuid, closeDateAfter, (ResultHandler)handler);
        return ImmutableList.copyOf((Collection)handler.issues);
    }

    private static class ClosedIssuesResultHandler
    implements ResultHandler<IssueDto> {
        private final List<DefaultIssue> issues = new ArrayList<DefaultIssue>();
        private String previousIssueKey = null;

        private ClosedIssuesResultHandler() {
        }

        public void handleResult(ResultContext<? extends IssueDto> resultContext) {
            IssueDto resultObject = (IssueDto)resultContext.getResultObject();
            if (this.previousIssueKey != null && this.previousIssueKey.equals(resultObject.getKey())) {
                return;
            }
            FieldDiffs fieldDiffs = FieldDiffs.parse((String)((String)resultObject.getClosedChangeData().orElseThrow(() -> new IllegalStateException("Close change data should be populated"))));
            Preconditions.checkState((boolean)Optional.ofNullable(fieldDiffs.get("status")).map(FieldDiffs.Diff::newValue).filter("CLOSED"::equals).isPresent(), (String)"Close change data should have a status diff with new value %s", (Object[])new Object[]{"CLOSED"});
            Integer line = Optional.ofNullable(fieldDiffs.get("line")).map(diff -> (String)((Object)diff.oldValue())).filter(str -> !str.isEmpty()).map(Integer::parseInt).orElse(null);
            this.previousIssueKey = resultObject.getKey();
            DefaultIssue issue = resultObject.toDefaultIssue();
            issue.setLine(line);
            issue.setSelectedAt(Long.valueOf(System.currentTimeMillis()));
            this.issues.add(issue);
        }
    }
}

