/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.sonar.api.rules.RuleType;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.issue.DebtCalculator;
import org.sonar.ce.task.projectanalysis.issue.Rule;
import org.sonar.ce.task.projectanalysis.issue.RuleRepository;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.DefaultIssueComment;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.util.Uuids;
import org.sonar.db.component.KeyType;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.workflow.IssueWorkflow;

public class IssueLifecycle {
    private final IssueWorkflow workflow;
    private final IssueChangeContext changeContext;
    private final RuleRepository ruleRepository;
    private final IssueFieldsSetter updater;
    private final DebtCalculator debtCalculator;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public IssueLifecycle(AnalysisMetadataHolder analysisMetadataHolder, IssueWorkflow workflow, IssueFieldsSetter updater, DebtCalculator debtCalculator, RuleRepository ruleRepository) {
        this(analysisMetadataHolder, IssueChangeContext.createScan((Date)new Date(analysisMetadataHolder.getAnalysisDate())), workflow, updater, debtCalculator, ruleRepository);
    }

    @VisibleForTesting
    IssueLifecycle(AnalysisMetadataHolder analysisMetadataHolder, IssueChangeContext changeContext, IssueWorkflow workflow, IssueFieldsSetter updater, DebtCalculator debtCalculator, RuleRepository ruleRepository) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.workflow = workflow;
        this.updater = updater;
        this.debtCalculator = debtCalculator;
        this.changeContext = changeContext;
        this.ruleRepository = ruleRepository;
    }

    public void initNewOpenIssue(DefaultIssue issue) {
        Preconditions.checkArgument((issue.isFromExternalRuleEngine() != (issue.type() == null) ? 1 : 0) != 0, (Object)"At this stage issue type should be set for and only for external issues");
        Rule rule = this.ruleRepository.getByKey(issue.ruleKey());
        issue.setKey(Uuids.create());
        issue.setCreationDate(this.changeContext.date());
        issue.setUpdateDate(this.changeContext.date());
        issue.setEffort(this.debtCalculator.calculate(issue));
        issue.setIsFromHotspot(rule.getType() == RuleType.SECURITY_HOTSPOT);
        this.setType(issue, rule);
        this.setStatus(issue, rule);
    }

    private void setType(DefaultIssue issue, Rule rule) {
        if (issue.isFromExternalRuleEngine()) {
            return;
        }
        issue.setType(Objects.requireNonNull(rule.getType(), "No rule type"));
    }

    private void setStatus(DefaultIssue issue, Rule rule) {
        if (issue.isFromExternalRuleEngine() || rule.getType() != RuleType.SECURITY_HOTSPOT) {
            issue.setStatus("OPEN");
        } else {
            issue.setStatus("TO_REVIEW");
        }
    }

    public void copyExistingOpenIssueFromLongLivingBranch(DefaultIssue raw, DefaultIssue base, String fromLongBranchName) {
        raw.setKey(Uuids.create());
        raw.setNew(false);
        this.copyAttributesOfIssueFromOtherBranch(raw, base);
        raw.setFieldChange(this.changeContext, "from_long_branch", (Serializable)((Object)fromLongBranchName), (Serializable)((Object)this.analysisMetadataHolder.getBranch().getName()));
    }

    public void mergeConfirmedOrResolvedFromShortLivingBranchOrPr(DefaultIssue raw, DefaultIssue base, KeyType branchType, String fromShortBranchNameOrPR) {
        this.copyAttributesOfIssueFromOtherBranch(raw, base);
        String from = (branchType == KeyType.PULL_REQUEST ? "#" : "") + fromShortBranchNameOrPR;
        String to = this.analysisMetadataHolder.isPullRequest() ? "#" + this.analysisMetadataHolder.getPullRequestKey() : this.analysisMetadataHolder.getBranch().getName();
        raw.setFieldChange(this.changeContext, "from_short_branch", (Serializable)((Object)from), (Serializable)((Object)to));
    }

    private void copyAttributesOfIssueFromOtherBranch(DefaultIssue to, DefaultIssue from) {
        to.setCopied(true);
        this.copyFields(to, from);
        if (from.manualSeverity()) {
            to.setManualSeverity(true);
            to.setSeverity(from.severity());
        }
        IssueLifecycle.copyChangesOfIssueFromOtherBranch(to, from);
    }

    private static void copyChangesOfIssueFromOtherBranch(DefaultIssue raw, DefaultIssue base) {
        base.defaultIssueComments().forEach(c -> raw.addComment(IssueLifecycle.copyComment(raw.key(), c)));
        base.changes().forEach(c -> IssueLifecycle.copyFieldDiffOfIssueFromOtherBranch(raw.key(), c).ifPresent(arg_0 -> ((DefaultIssue)raw).addChange(arg_0)));
    }

    private static DefaultIssueComment copyComment(String issueKey, DefaultIssueComment c) {
        DefaultIssueComment comment = new DefaultIssueComment();
        comment.setIssueKey(issueKey);
        comment.setKey(Uuids.create());
        comment.setUserUuid(c.userUuid());
        comment.setMarkdownText(c.markdownText());
        comment.setCreatedAt(c.createdAt()).setUpdatedAt(c.updatedAt());
        comment.setNew(true);
        return comment;
    }

    private static Optional<FieldDiffs> copyFieldDiffOfIssueFromOtherBranch(String issueKey, FieldDiffs c) {
        FieldDiffs result = new FieldDiffs();
        result.setIssueKey(issueKey);
        result.setUserUuid(c.userUuid());
        result.setCreationDate(c.creationDate());
        c.diffs().entrySet().stream().filter(e -> !((String)e.getKey()).equals("file")).forEach(e -> result.setDiff((String)e.getKey(), ((FieldDiffs.Diff)e.getValue()).oldValue(), ((FieldDiffs.Diff)e.getValue()).newValue()));
        if (result.diffs().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public void mergeExistingOpenIssue(DefaultIssue raw, DefaultIssue base) {
        Preconditions.checkArgument((raw.isFromExternalRuleEngine() != (raw.type() == null) ? 1 : 0) != 0, (Object)"At this stage issue type should be set for and only for external issues");
        Rule rule = this.ruleRepository.getByKey(raw.ruleKey());
        raw.setKey(base.key());
        raw.setNew(false);
        if (base.isChanged()) {
            raw.setChanged(true);
        }
        raw.setIsFromHotspot(rule.getType() == RuleType.SECURITY_HOTSPOT);
        this.setType(raw, rule);
        this.copyFields(raw, base);
        base.changes().forEach(arg_0 -> ((DefaultIssue)raw).addChange(arg_0));
        if (raw.isFromHotspot() != base.isFromHotspot()) {
            raw.setChanged(true);
        }
        if (raw.isFromHotspot() && !base.isFromHotspot()) {
            this.updater.setType(raw, RuleType.SECURITY_HOTSPOT, this.changeContext);
            this.updater.setStatus(raw, "TO_REVIEW", this.changeContext);
            this.updater.setResolution(raw, null, this.changeContext);
        }
        if (base.manualSeverity()) {
            raw.setManualSeverity(true);
            raw.setSeverity(base.severity());
        } else {
            this.updater.setPastSeverity(raw, base.severity(), this.changeContext);
        }
        raw.setComponentUuid(base.componentUuid());
        raw.setComponentKey(base.componentKey());
        raw.setModuleUuid(base.moduleUuid());
        raw.setModuleUuidPath(base.moduleUuidPath());
        this.updater.setPastLine(raw, base.getLine());
        this.updater.setPastLocations(raw, base.getLocations());
        this.updater.setPastMessage(raw, base.getMessage(), this.changeContext);
        this.updater.setPastGap(raw, base.gap(), this.changeContext);
        this.updater.setPastEffort(raw, base.effort(), this.changeContext);
    }

    public void doAutomaticTransition(DefaultIssue issue) {
        this.workflow.doAutomaticTransition(issue, this.changeContext);
    }

    private void copyFields(DefaultIssue toIssue, DefaultIssue fromIssue) {
        toIssue.setType(fromIssue.type());
        toIssue.setCreationDate(fromIssue.creationDate());
        toIssue.setUpdateDate(fromIssue.updateDate());
        toIssue.setCloseDate(fromIssue.closeDate());
        toIssue.setResolution(fromIssue.resolution());
        toIssue.setStatus(fromIssue.status());
        toIssue.setAssigneeUuid(fromIssue.assignee());
        toIssue.setAuthorLogin(fromIssue.authorLogin());
        toIssue.setTags((Collection)fromIssue.tags());
        toIssue.setAttributes(fromIssue.attributes());
        toIssue.setEffort(this.debtCalculator.calculate(toIssue));
        toIssue.setOnDisabledRule(fromIssue.isOnDisabledRule());
        toIssue.setSelectedAt(fromIssue.selectedAt());
    }
}

