/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.DefaultTrackingInput;
import org.sonar.ce.task.projectanalysis.issue.IssueLocations;
import org.sonar.ce.task.projectanalysis.issue.TrackerBaseInputFactory;
import org.sonar.ce.task.projectanalysis.issue.TrackerMergeOrTargetBranchInputFactory;
import org.sonar.ce.task.projectanalysis.issue.TrackerRawInputFactory;
import org.sonar.ce.task.projectanalysis.source.NewLinesRepository;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.NonClosedTracking;
import org.sonar.core.issue.tracking.Tracker;
import org.sonar.core.issue.tracking.Tracking;
import org.sonar.core.util.stream.MoreCollectors;

public class ShortBranchOrPullRequestTrackerExecution {
    private final TrackerBaseInputFactory baseInputFactory;
    private final TrackerRawInputFactory rawInputFactory;
    private final TrackerMergeOrTargetBranchInputFactory mergeInputFactory;
    private final Tracker<DefaultIssue, DefaultIssue> tracker;
    private final NewLinesRepository newLinesRepository;

    public ShortBranchOrPullRequestTrackerExecution(TrackerBaseInputFactory baseInputFactory, TrackerRawInputFactory rawInputFactory, TrackerMergeOrTargetBranchInputFactory mergeInputFactory, Tracker<DefaultIssue, DefaultIssue> tracker, NewLinesRepository newLinesRepository) {
        this.baseInputFactory = baseInputFactory;
        this.rawInputFactory = rawInputFactory;
        this.mergeInputFactory = mergeInputFactory;
        this.tracker = tracker;
        this.newLinesRepository = newLinesRepository;
    }

    public Tracking<DefaultIssue, DefaultIssue> track(Component component) {
        DefaultTrackingInput unmatchedRawsAfterChangedLineFiltering;
        DefaultTrackingInput unmatchedRawsAfterTargetBranchTracking;
        DefaultTrackingInput unmatchedRawsAfterMergeBranchTracking;
        DefaultTrackingInput rawInput = this.rawInputFactory.create(component);
        Input<DefaultIssue> previousAnalysisInput = this.baseInputFactory.create(component);
        if (this.mergeInputFactory.hasMergeBranchAnalysis()) {
            Input<DefaultIssue> mergeInput = this.mergeInputFactory.createForMergeBranch(component);
            NonClosedTracking mergeTracking = this.tracker.trackNonClosed(rawInput, mergeInput);
            List unmatchedRaws = (List)mergeTracking.getUnmatchedRaws().collect(MoreCollectors.toList());
            unmatchedRawsAfterMergeBranchTracking = new DefaultTrackingInput(unmatchedRaws, rawInput.getLineHashSequence(), rawInput.getBlockHashSequence());
        } else {
            unmatchedRawsAfterMergeBranchTracking = rawInput;
        }
        if (this.mergeInputFactory.hasTargetBranchAnalysis() && this.mergeInputFactory.areTargetAndMergeBranchesDifferent()) {
            Input<DefaultIssue> targetInput = this.mergeInputFactory.createForTargetBranch(component);
            NonClosedTracking mergeTracking = this.tracker.trackNonClosed(unmatchedRawsAfterMergeBranchTracking, targetInput);
            List unmatchedRaws = (List)mergeTracking.getUnmatchedRaws().collect(MoreCollectors.toList());
            unmatchedRawsAfterTargetBranchTracking = new DefaultTrackingInput(unmatchedRaws, rawInput.getLineHashSequence(), rawInput.getBlockHashSequence());
        } else {
            unmatchedRawsAfterTargetBranchTracking = unmatchedRawsAfterMergeBranchTracking;
        }
        if (!this.mergeInputFactory.hasTargetBranchAnalysis() || !this.mergeInputFactory.hasMergeBranchAnalysis()) {
            List<DefaultIssue> filteredRaws = this.keepIssuesHavingAtLeastOneLocationOnChangedLines(component, unmatchedRawsAfterTargetBranchTracking.getIssues());
            unmatchedRawsAfterChangedLineFiltering = new DefaultTrackingInput(filteredRaws, rawInput.getLineHashSequence(), rawInput.getBlockHashSequence());
        } else {
            unmatchedRawsAfterChangedLineFiltering = unmatchedRawsAfterTargetBranchTracking;
        }
        return this.tracker.trackNonClosed(unmatchedRawsAfterChangedLineFiltering, previousAnalysisInput);
    }

    private List<DefaultIssue> keepIssuesHavingAtLeastOneLocationOnChangedLines(Component component, Collection<DefaultIssue> issues) {
        if (component.getType() != Component.Type.FILE) {
            return Collections.emptyList();
        }
        Optional<Set<Integer>> newLinesOpt = this.newLinesRepository.getNewLines(component);
        if (!newLinesOpt.isPresent()) {
            return Collections.emptyList();
        }
        Set<Integer> newLines = newLinesOpt.get();
        return issues.stream().filter(i -> IssueLocations.allLinesFor(i, component.getUuid()).anyMatch(newLines::contains)).collect(Collectors.toList());
    }
}

